/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.data.CasAbstractValue;
import com.dbeaver.ee.cassandra.model.CasAbstractDataType;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class CasListValue
extends CasAbstractValue
implements DBDCollection,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasListValue.class);
    private List<Object> contents;
    private DataType type;
    private CasAbstractDataType componentType;
    private boolean modified;

    public CasListValue(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull CasDataSource casDataSource, String string, @Nullable List<Object> list, DataType dataType) {
        super(casDataSource, string);
        Object object2;
        if (list == null) {
            this.contents = new ArrayList<Object>();
        } else {
            this.contents = new ArrayList<Object>(list.size());
            for (Object object2 : list) {
                try {
                    this.contents.add(CasUtils.wrapValue(casDataSource, string, object2));
                }
                catch (DBCException dBCException) {
                    log.error((Object)"Error wrapping list value", (Throwable)dBCException);
                }
            }
        }
        this.type = dataType;
        object2 = dataType.getTypeArguments();
        if (CommonUtils.isEmpty((Collection)object2) || object2.size() != 1) {
            log.error((Object)("Bad Cassandra list data type arguments (" + object2 + ")"));
        } else {
            try {
                this.componentType = CasUtils.resolveDataType(dBRProgressMonitor, casDataSource, string, (DataType)object2.get(0));
            }
            catch (Exception exception) {
                log.error((Object)"Error resolving list type", (Throwable)exception);
            }
        }
        if (this.componentType == null) {
            this.componentType = casDataSource.getLocalDataType(dataType.getName().toString());
        }
    }

    public CasListValue(CasDataSource casDataSource, CasListValue casListValue) {
        this((DBRProgressMonitor)new VoidProgressMonitor(), casDataSource, casListValue.keyspace, casListValue.contents, casListValue.type);
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.componentType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor dBRProgressMonitor) {
        return new CasListValue(dBRProgressMonitor, this.dataSource, this.keyspace, this.contents, this.type);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        DBDValueHandler dBDValueHandler = this.getComponentValueHandler();
        StringBuilder stringBuilder = new StringBuilder(this.contents.size() * 32);
        stringBuilder.append("[");
        int n = 0;
        while (n < this.contents.size()) {
            Object object = this.contents.get(n);
            if (n > 0) {
                stringBuilder.append(',');
            }
            String string = dBDValueHandler.getValueDisplayString((DBSTypedObject)this.componentType, object, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)stringBuilder, (DBSTypedObject)this.componentType, (Object)string);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public Object getItem(int n) {
        return this.contents.get(n);
    }

    public void setItem(int n, Object object) {
        this.contents.set(n, object);
        this.modified = true;
    }

    public void setContents(Object[] objectArray) {
        if (this.contents == null) {
            this.contents = new ArrayList<Object>();
        } else {
            this.contents.clear();
        }
        Collections.addAll(this.contents, objectArray);
        this.modified = true;
    }

    public List<Object> makeList() {
        if (this.contents == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.contents.size());
        for (Object object : this.contents) {
            arrayList.add(CasUtils.unwrapValue(this.dataSource, object));
        }
        return arrayList;
    }
}

