/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.tools.maintenance.OracleMaintenanceDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class OracleToolValidateStructure
implements IExternalTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, OracleTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends OracleMaintenanceDialog<OracleTable> {
        private Button cascadeCheck;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<OracleTable> selectedTables) {
            super(partSite, "Validate table(s) structure", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, OracleTable object) {
            String sql = "ANALYZE TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + " VALIDATE STRUCTURE";
            if (this.cascadeCheck.getSelection()) {
                sql = String.valueOf(sql) + " CASCADE";
            }
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.cascadeCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Cascade", (boolean)false);
            this.cascadeCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

