/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.model.VQBJoinType;
import java.util.ArrayList;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

class VQBPanelQueryJoins
extends VQBPanelQueryElements<Object> {
    protected VQBPanelQueryJoins(VQBEditorPresentation vQBEditorPresentation) {
        super(vQBEditorPresentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Join) {
                    return this.getChildren(object);
                }
                return super.getElements(object);
            }

            public Object[] getChildren(Object object) {
                if (object instanceof Join) {
                    Expression expression = VQBPanelQueryJoins.this.getJoinConditions((Join)object);
                    if (expression == null) {
                        return null;
                    }
                    ArrayList<Expression> arrayList = new ArrayList<Expression>();
                    if (VQBUtils.isCompoundExpression(expression)) {
                        VQBUtils.collectNestedConditions(VQBPanelQueryJoins.this.getQueryInfo(), arrayList, expression, expression);
                    } else {
                        arrayList.add(expression);
                    }
                    return arrayList.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object object) {
                if (object instanceof Join) {
                    return VQBPanelQueryJoins.this.getJoinConditions((Join)object) != null;
                }
                return false;
            }
        };
    }

    @Override
    protected void loadElements() {
        SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.elementViewer.setInput((Object)((PlainSelect)selectBody).getJoins());
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Object> viewerColumnController) {
        super.fillColumns(viewerColumnController);
        viewerColumnController.addColumn("Table / Conditions", "Joined table and join conditions", 16384, true, true, object -> {
            if (object instanceof Join) {
                FromItem fromItem = ((Join)object).getRightItem();
                if (fromItem instanceof Table) {
                    return ((Table)fromItem).getFullyQualifiedName();
                }
            } else if (object instanceof Expression) {
                return object.toString();
            }
            return null;
        }, null);
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object object) {
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryJoins.this.elementViewer, (Composite)VQBPanelQueryJoins.this.elementViewer.getTree(), new String[0], 12);
                VQBJoinType[] vQBJoinTypeArray = VQBJoinType.values();
                ArrayList<String> arrayList = new ArrayList<String>();
                VQBJoinType[] vQBJoinTypeArray2 = vQBJoinTypeArray;
                int n = vQBJoinTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VQBJoinType vQBJoinType = vQBJoinTypeArray2[n2];
                    if (vQBJoinType.isSupported()) {
                        arrayList.add(vQBJoinType.getName());
                    }
                    ++n2;
                }
                customComboBoxCellEditor.setItems(arrayList.toArray(new String[arrayList.size()]));
                return customComboBoxCellEditor;
            }

            protected boolean canEdit(Object object) {
                return object instanceof Join;
            }

            protected Object getValue(Object object) {
                if (object instanceof Join) {
                    return VQBJoinType.getByJoin((Join)object).getName();
                }
                return null;
            }

            protected void setValue(Object object, Object object2) {
                VQBJoinType vQBJoinType;
                VQBJoinType vQBJoinType2;
                if (object instanceof Join && (vQBJoinType2 = VQBJoinType.getByJoin((Join)object)) != (vQBJoinType = VQBJoinType.getByName((String)object2))) {
                    vQBJoinType.setJoinType((Join)object);
                    VQBPanelQueryJoins.this.refreshDiagramAndStatement();
                }
            }
        };
        viewerColumnController.addColumn("Type", "Join type", 16384, true, true, object -> {
            if (object instanceof Join) {
                return VQBJoinType.getByJoin((Join)object).getName();
            }
            return null;
        }, editingSupport);
        VQBPanelQueryElements.TextEditingSupport<Object> textEditingSupport = new VQBPanelQueryElements.TextEditingSupport<Object>((VQBPanelQueryElements)this){

            @Override
            protected boolean canEdit(Object object) {
                return object instanceof Join;
            }

            @Override
            protected String convertExpressionToString(Object object) {
                if (object instanceof Join) {
                    Alias alias = ((Join)object).getRightItem().getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return null;
            }

            @Override
            protected void updateElementText(Object object, String string) {
                if (object instanceof Join) {
                    Alias alias;
                    Alias alias2 = alias = CommonUtils.isEmpty((String)string) ? null : new Alias(string);
                    if (((Join)object).getRightItem() instanceof Table) {
                        VQBUtils.updateTableAlias(VQBPanelQueryJoins.this.getQueryInfo(), (Table)((Join)object).getRightItem(), alias);
                    }
                }
            }
        };
        viewerColumnController.addColumn("Alias", "Table alias", 16384, true, true, object -> {
            if (object instanceof Join) {
                Alias alias = ((Join)object).getRightItem().getAlias();
                return alias == null ? null : alias.getName();
            }
            return null;
        }, (EditingSupport)textEditingSupport);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return null;
    }

    private Expression getJoinConditions(Join join) {
        if (join.isSimple()) {
            return null;
        }
        return join.getOnExpression();
    }
}

