/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.QueryExpressionTransfer;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.sql.parser.CustomExpression;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.utils.CommonUtils;

abstract class VQBPanelQueryElements<ELEMENT_TYPE>
extends TabbedFolderPage
implements IAdaptable {
    protected final VQBEditorPresentation presentation;
    protected TreeViewer elementViewer;
    protected ViewerColumnController<Object, ELEMENT_TYPE> columnsController;
    protected volatile boolean isNewElement;

    protected VQBPanelQueryElements(VQBEditorPresentation vQBEditorPresentation) {
        this.presentation = vQBEditorPresentation;
    }

    protected VQBQueryInfo getQueryInfo() {
        return this.presentation.getVQBEditor().getQueryInfo();
    }

    public void createControl(Composite composite) {
        this.elementViewer = new TreeViewer(composite, 66304);
        Tree tree = this.elementViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.elementViewer.setContentProvider((IContentProvider)this.makeContentProvider());
        this.elementViewer.addSelectionChangedListener(selectionChangedEvent -> {
            VQBEditorQueryPanel vQBEditorQueryPanel = this.presentation.getQueryPanel();
            if (vQBEditorQueryPanel != null) {
                vQBEditorQueryPanel.updateActions();
            }
        });
        if (this.supportsElementsMove()) {
            Transfer[] transferArray = new Transfer[]{QueryExpressionTransfer.getInstance()};
            int n = 7;
            DragSource dragSource = new DragSource(this.elementViewer.getControl(), n);
            dragSource.setTransfer(transferArray);
            dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    dragSourceEvent.data = VQBPanelQueryElements.this.getSelectedElement();
                }
            });
            DropTarget dropTarget = new DropTarget(this.elementViewer.getControl(), n);
            dropTarget.setTransfer(transferArray);
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void drop(DropTargetEvent dropTargetEvent) {
                    if (dropTargetEvent.item == null) {
                        return;
                    }
                    Object object = dropTargetEvent.item.getData();
                    if (object != dropTargetEvent.data) {
                        VQBPanelQueryElements.this.moveElementTo(dropTargetEvent.data, object);
                    }
                }
            });
        }
    }

    protected boolean supportsElementsMove() {
        return false;
    }

    protected void moveElementTo(ELEMENT_TYPE ELEMENT_TYPE, ELEMENT_TYPE ELEMENT_TYPE2) {
        throw new IllegalStateException("Move not supported");
    }

    protected void fillPanelContributions(IContributionManager iContributionManager) {
        iContributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.presentation.getSQLEditor().getEditorSite(), (String)"com.dbeaver.ee.vqb.ui.show.preview", (int)32));
        iContributionManager.add((IContributionItem)new Separator());
    }

    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getChildren(Object object) {
                return new Object[0];
            }

            public boolean hasChildren(Object object) {
                return false;
            }
        };
    }

    public void setFocus() {
        this.elementViewer.getControl().setFocus();
    }

    public void aboutToBeShown() {
        if (this.columnsController == null) {
            this.columnsController = new ViewerColumnController(((Object)((Object)this)).getClass().getSimpleName(), (ColumnViewer)this.elementViewer);
            this.columnsController.setDefaultIcon(this.getDefaultIcon());
            this.fillColumns(this.columnsController);
            this.loadElements();
            this.columnsController.createColumns();
            Control control = this.elementViewer.getControl();
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu(control);
            menuManager.addMenuListener(iMenuManager -> {
                if (this.columnsController.isClickOnHeader()) {
                    this.columnsController.fillConfigMenu((IContributionManager)iMenuManager);
                    iMenuManager.add((IContributionItem)new Separator());
                } else {
                    this.fillPanelContributions((IContributionManager)iMenuManager);
                }
            });
            menuManager.setRemoveAllWhenShown(true);
            control.setMenu(menu);
            control.addDisposeListener(disposeEvent -> menuManager.dispose());
        }
    }

    public void aboutToBeHidden() {
    }

    protected void loadElements() {
    }

    protected void fillColumns(ViewerColumnController<Object, ELEMENT_TYPE> viewerColumnController) {
    }

    @Nullable
    protected DBIcon getDefaultIcon() {
        return null;
    }

    public <T> T getAdapter(Class<T> clazz) {
        return null;
    }

    @Nullable
    protected PlainSelect getPlainSelect() {
        return this.getQueryInfo().getPlainSelect();
    }

    public ELEMENT_TYPE getSelectedElement() {
        ISelection iSelection = this.elementViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            return (ELEMENT_TYPE)((IStructuredSelection)iSelection).getFirstElement();
        }
        return null;
    }

    public ELEMENT_TYPE getParentElement() {
        TreeItem treeItem;
        Object object = null;
        TreeItem[] treeItemArray = this.elementViewer.getTree().getSelection();
        if (treeItemArray.length == 1 && (treeItem = treeItemArray[0].getParentItem()) != null) {
            object = treeItem.getData();
        }
        return (ELEMENT_TYPE)object;
    }

    public void addNewElement(ELEMENT_TYPE ELEMENT_TYPE, int n) {
        this.elementViewer.refresh();
        this.elementViewer.expandAll();
        this.presentation.getQueryPanel().refreshFromStatement(false);
        this.elementViewer.editElement(ELEMENT_TYPE, n);
    }

    public void refreshFromStatement() {
        if (this.elementViewer != null) {
            this.elementViewer.getTree().setRedraw(false);
            try {
                this.loadElements();
            }
            finally {
                this.elementViewer.getTree().setRedraw(true);
            }
        }
    }

    protected void refreshDiagramAndStatement() {
        this.presentation.getVQBEditor().scheduleQueryGenerator();
    }

    public void editElement(Object object) {
        int n = this.columnsController.getEditableColumnIndex(object);
        if (n >= 0) {
            this.elementViewer.editElement(object, n);
        }
    }

    protected abstract class DeleteActionAbstract
    extends Action {
        DeleteActionAbstract() {
            super("Remove", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE));
        }

        public void run() {
            List list;
            Object ELEMENT_TYPE = VQBPanelQueryElements.this.getSelectedElement();
            if (ELEMENT_TYPE != null && (list = this.getElementsContainer()) != null) {
                list.remove(ELEMENT_TYPE);
                VQBPanelQueryElements.this.refreshDiagramAndStatement();
            }
        }

        public boolean isEnabled() {
            return VQBPanelQueryElements.this.getSelectedElement() != null;
        }

        protected abstract List<ELEMENT_TYPE> getElementsContainer();
    }

    protected abstract class ExpressionEditingSupport<ITEM>
    extends EditingSupport {
        public ExpressionEditingSupport() {
            super((ColumnViewer)VQBPanelQueryElements.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object object) {
            TextCellEditor textCellEditor = new TextCellEditor((Composite)VQBPanelQueryElements.this.elementViewer.getTree());
            UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryElements.this.presentation.getSQLEditor().getSite(), (Control)textCellEditor.getControl());
            return textCellEditor;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected Object getValue(Object object) {
            return this.convertExpressionToString(object);
        }

        protected final void setValue(Object object, Object object2) {
            String string = (String)object2;
            if (!VQBPanelQueryElements.this.isNewElement && CommonUtils.equalObjects((Object)this.getValue(object), (Object)string)) {
                return;
            }
            VQBPanelQueryElements.this.isNewElement = false;
            if (this.setValue(object, string.trim())) {
                VQBPanelQueryElements.this.refreshDiagramAndStatement();
            }
        }

        protected boolean setValue(ITEM ITEM, String string) {
            try {
                Object ELEMENT_TYPE = VQBPanelQueryElements.this.getParentElement();
                Expression expression = this.parseNewExpression(string);
                return this.updateElementExpression(ELEMENT_TYPE, ITEM, expression);
            }
            catch (JSQLParserException jSQLParserException) {
                DBUserInterface.getInstance().showError("Parse error", "Error parsing expression", (Throwable)jSQLParserException);
                return false;
            }
        }

        protected Expression parseNewExpression(String string) throws JSQLParserException {
            if (CommonUtils.isEmpty((String)string)) {
                return null;
            }
            try {
                return CCJSqlParserUtil.parseExpression((String)string, (boolean)false);
            }
            catch (JSQLParserException jSQLParserException) {
                return new CustomExpression(string);
            }
        }

        protected String convertExpressionToString(ITEM ITEM) {
            return ITEM.toString();
        }

        protected abstract boolean updateElementExpression(ELEMENT_TYPE var1, ITEM var2, Expression var3);
    }

    protected abstract class TextEditingSupport<ITEM>
    extends EditingSupport {
        public TextEditingSupport() {
            super((ColumnViewer)VQBPanelQueryElements.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object object) {
            TextCellEditor textCellEditor = new TextCellEditor((Composite)VQBPanelQueryElements.this.elementViewer.getTree());
            UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryElements.this.presentation.getSQLEditor().getSite(), (Control)textCellEditor.getControl());
            return textCellEditor;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected Object getValue(Object object) {
            return this.convertExpressionToString(object);
        }

        protected void setValue(Object object, Object object2) {
            String string = (String)object2;
            if (!VQBPanelQueryElements.this.isNewElement && CommonUtils.equalObjects((Object)this.getValue(object), (Object)string)) {
                return;
            }
            this.updateElementText(object, string);
            VQBPanelQueryElements.this.isNewElement = false;
            VQBPanelQueryElements.this.refreshDiagramAndStatement();
        }

        protected abstract String convertExpressionToString(ITEM var1);

        protected abstract void updateElementText(ITEM var1, String var2);
    }
}

