/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.commands.VQBDiagramCommand;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.command.AssociationCreateCommand;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.utils.CommonUtils;

public class JoinCreateCommand
extends AssociationCreateCommand
implements VQBDiagramCommand {
    private static final Log log = Log.getLog(JoinCreateCommand.class);
    private final EntityDiagram entityDiagram;
    private final VQBQueryInfo queryInfo;
    private ERDEntityAttribute sourceAttribute;
    private ERDEntityAttribute targetAttribute;

    public JoinCreateCommand(EntityDiagram entityDiagram, VQBQueryInfo vQBQueryInfo) {
        this.entityDiagram = entityDiagram;
        this.queryInfo = vQBQueryInfo;
    }

    protected ERDAssociation createAssociation(ERDEntity eRDEntity, ERDEntity eRDEntity2, boolean bl) {
        ERDJoin eRDJoin = new ERDJoin(eRDEntity, eRDEntity2, bl);
        if (this.sourceAttribute != null && this.targetAttribute != null) {
            eRDJoin.addCondition(this.sourceAttribute, this.targetAttribute);
        }
        return eRDJoin;
    }

    public void setAttributes(ERDEntityAttribute eRDEntityAttribute, ERDEntityAttribute eRDEntityAttribute2) {
        this.sourceAttribute = eRDEntityAttribute;
        this.targetAttribute = eRDEntityAttribute2;
    }

    public boolean canExecute() {
        return this.sourceAttribute != null && this.targetAttribute != null && !CommonUtils.equalObjects((Object)this.sourceAttribute, (Object)this.targetAttribute);
    }

    public void execute() {
        this.association = this.execute(false);
    }

    public void undo() {
        super.undo();
        this.execute(true);
        this.association = null;
    }

    private ERDJoin execute(boolean bl) {
        ERDJoin eRDJoin = null;
        PlainSelect plainSelect = this.queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!bl) {
                Join join = VQBUtils.findEntityJoin(this.entityDiagram, plainSelect, this.sourceEntity, this.targetEntity);
                if (join != null) {
                    join.setInner(true);
                    eRDJoin = VQBUtils.findERDJoin(this.entityDiagram, join);
                    if (eRDJoin != null) {
                        eRDJoin.addCondition(this.sourceAttribute, this.targetAttribute);
                        eRDJoin.updateStatementJoin(join);
                    } else {
                        eRDJoin = new ERDJoin(this.sourceEntity, this.targetEntity, true);
                        eRDJoin.setUserData(join);
                        eRDJoin.addCondition(this.sourceAttribute, this.targetAttribute);
                        eRDJoin.updateStatementJoin(join);
                    }
                } else {
                    eRDJoin = new ERDJoin(this.sourceEntity, this.targetEntity, true);
                    eRDJoin.addCondition(this.sourceAttribute, this.targetAttribute);
                    join = eRDJoin.createStatementJoin();
                    VQBUtils.getQueryJoins(plainSelect).add(join);
                }
            } else {
                eRDJoin = (ERDJoin)this.association;
                Join join = (Join)eRDJoin.getUserData();
                List list = plainSelect.getJoins();
                if (list != null) {
                    list.remove(join);
                }
            }
        }
        return eRDJoin;
    }
}

