/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.builder;

import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLIdentifierDetector;
import org.jkiss.utils.CommonUtils;

public class VQBQueryGenerator {
    private static final Log log = Log.getLog(VQBQueryGenerator.class);
    private DBPDataSource dataSource;
    private SQLIdentifierDetector identifierDetector;

    public VQBQueryGenerator(DBPDataSource dBPDataSource) {
        this.dataSource = dBPDataSource;
        SQLDialect sQLDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dBPDataSource);
        this.identifierDetector = new SQLIdentifierDetector(sQLDialect.getStructSeparator(), sQLDialect.getIdentifierQuoteStrings());
    }

    /*
     * WARNING - void declaration
     */
    public SQLQuery generateQueryFromDiagram(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram) {
        void var7_12;
        Object object;
        Object object2;
        Object object32;
        List list = entityDiagram.getEntities();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT");
        ArrayList<SelectItemInfo> arrayList = new ArrayList<SelectItemInfo>();
        for (Object object32 : list) {
            object2 = object32.getCheckedAttributes();
            if (object2.size() == object32.getAttributes().size()) {
                arrayList.add(new SelectItemInfo(null, (ERDEntity)object32));
                continue;
            }
            for (Object object4 : object2) {
                arrayList.add(new SelectItemInfo((ERDEntityAttribute)object4, (ERDEntity)object32));
            }
        }
        if (arrayList.size() == 0) {
            stringBuilder.append(" *");
        } else {
            arrayList.sort((selectItemInfo, selectItemInfo2) -> {
                if (selectItemInfo.attribute == selectItemInfo2.attribute) {
                    return 0;
                }
                if (selectItemInfo.attribute == null) {
                    return -1;
                }
                if (selectItemInfo2.attribute == null) {
                    return 1;
                }
                return selectItemInfo.attribute.getOrder() - selectItemInfo2.attribute.getOrder();
            });
            int n = 0;
            while (n < arrayList.size()) {
                SelectItemInfo eRDEntity2 = (SelectItemInfo)arrayList.get(n);
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n\t");
                if (!CommonUtils.isEmpty((String)eRDEntity2.entity.getAlias())) {
                    stringBuilder.append(eRDEntity2.entity.getAlias());
                } else {
                    stringBuilder.append(DBUtils.getObjectFullName((DBPNamedObject)eRDEntity2.entity, (DBPEvaluationContext)DBPEvaluationContext.DML));
                }
                stringBuilder.append(".");
                if (eRDEntity2.attribute == null) {
                    stringBuilder.append("*");
                } else {
                    stringBuilder.append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)eRDEntity2.attribute.getName()));
                }
                ++n;
            }
        }
        stringBuilder.append("\n");
        arrayList = new ArrayList();
        object32 = new HashMap();
        for (ERDEntity eRDEntity2 : list) {
            boolean bl = false;
            for (ERDAssociation eRDAssociation : eRDEntity2.getAssociations()) {
                if (!(eRDAssociation instanceof ERDJoin)) continue;
                bl = true;
                object = object32.computeIfAbsent(eRDAssociation.getTargetEntity(), eRDEntity -> new ArrayList());
                object.add(eRDAssociation.getSourceEntity());
            }
            if (bl) continue;
            arrayList.add((SelectItemInfo)eRDEntity2);
        }
        stringBuilder.append("FROM ");
        boolean bl = false;
        while (var7_12 < arrayList.size()) {
            if (var7_12 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n\t");
            object2 = (ERDEntity)arrayList.get((int)var7_12);
            stringBuilder.append(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)object2.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DML));
            if (!CommonUtils.isEmpty((String)object2.getAlias())) {
                stringBuilder.append(" ").append(object2.getAlias());
            }
            ++var7_12;
        }
        stringBuilder.append("\n");
        for (ERDEntity eRDEntity3 : arrayList) {
            Object object4;
            object4 = (List)object32.get(eRDEntity3);
            if (object4 == null) continue;
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                ERDAssociation eRDAssociation;
                eRDAssociation = (ERDEntity)iterator.next();
                object = null;
                for (ERDAssociation eRDAssociation2 : eRDAssociation.getAssociations()) {
                    if (!(eRDAssociation2 instanceof ERDJoin) || eRDAssociation2.getTargetEntity() != eRDEntity3) continue;
                    object = (ERDJoin)eRDAssociation2;
                    break;
                }
                if (object == null) {
                    log.debug((Object)("Can't find join for " + eRDAssociation + " with " + eRDEntity3));
                    continue;
                }
                this.generateJoin(stringBuilder, (ERDJoin)((Object)object));
            }
        }
        SQLQuery sQLQuery = new SQLQuery(this.dataSource, stringBuilder.toString());
        return sQLQuery;
    }

    private void generateJoin(StringBuilder stringBuilder, ERDJoin eRDJoin) {
        ERDEntity eRDEntity = eRDJoin.getSourceEntity();
        ERDEntity eRDEntity2 = eRDJoin.getTargetEntity();
        stringBuilder.append("JOIN ").append(DBUtils.getObjectFullName((DBPNamedObject)eRDEntity, (DBPEvaluationContext)DBPEvaluationContext.DML));
        String string = "";
        String string2 = "";
        if (!CommonUtils.isEmpty((String)eRDEntity.getAlias())) {
            stringBuilder.append(" ").append(eRDEntity.getAlias());
            string = eRDEntity.getAlias();
        } else {
            string = DBUtils.getObjectFullName((DBPNamedObject)eRDEntity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        string2 = !CommonUtils.isEmpty((String)eRDEntity2.getAlias()) ? eRDEntity2.getAlias() : DBUtils.getObjectFullName((DBPNamedObject)eRDEntity2, (DBPEvaluationContext)DBPEvaluationContext.DML);
        stringBuilder.append("\n\tON  ");
        List list = eRDJoin.getSourceAttributes();
        List list2 = eRDJoin.getTargetAttributes();
        int n = 0;
        while (n < list.size()) {
            ERDEntityAttribute eRDEntityAttribute = (ERDEntityAttribute)list.get(n);
            ERDEntityAttribute eRDEntityAttribute2 = (ERDEntityAttribute)list2.get(n);
            if (n > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(string).append(".").append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)eRDEntityAttribute.getName()));
            stringBuilder.append(" = ");
            stringBuilder.append(string2).append(".").append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)eRDEntityAttribute2.getName()));
            ++n;
        }
        stringBuilder.append("\n");
    }

    private static class SelectItemInfo {
        ERDEntityAttribute attribute;
        ERDEntity entity;

        public SelectItemInfo(ERDEntityAttribute eRDEntityAttribute, ERDEntity eRDEntity) {
            this.attribute = eRDEntityAttribute;
            this.entity = eRDEntity;
        }
    }
}

