/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.ArrayList;
import java.util.List;
import nl.knaw.dans.common.dbflib.Type;

public enum Version {
    DBASE_3(254, 19, 1, 0, 6682, 2, Version.getDbase3Types()),
    DBASE_4(254, 20, 1, 8, 0, 0, Version.getDbase4Types()),
    DBASE_5(254, 20, 1, 8, 0, 0, Version.getDbase5Types()),
    CLIPPER_5(1024, 19, 2, 0, 26, 1, Version.getClipper5Types()),
    FOXPRO_26(254, 20, 1, 8, 0, 0, Version.getFoxProTypes());

    private final int maxLengthCharField;
    private final int maxLengthNumberField;
    private final int lengthHeaderTerminator;
    private final int memoDataOffset;
    private final int memoFieldEndMarker;
    private final int memoFieldEndMarkerLength;
    final List<Type> fieldTypes = new ArrayList<Type>();

    private static Type[] getDbase3Types() {
        return new Type[]{Type.CHARACTER, Type.NUMBER, Type.DATE, Type.LOGICAL, Type.MEMO};
    }

    private static Type[] getDbase4Types() {
        return new Type[]{Type.CHARACTER, Type.NUMBER, Type.DATE, Type.LOGICAL, Type.MEMO, Type.FLOAT};
    }

    private static Type[] getDbase5Types() {
        return new Type[]{Type.CHARACTER, Type.NUMBER, Type.DATE, Type.LOGICAL, Type.MEMO, Type.FLOAT, Type.BINARY, Type.GENERAL};
    }

    private static Type[] getClipper5Types() {
        return new Type[]{Type.CHARACTER, Type.NUMBER, Type.DATE, Type.LOGICAL, Type.MEMO};
    }

    private static Type[] getFoxProTypes() {
        return new Type[]{Type.CHARACTER, Type.NUMBER, Type.DATE, Type.LOGICAL, Type.MEMO, Type.FLOAT, Type.GENERAL, Type.PICTURE};
    }

    private Version(int maxLengthCharField, int maxLengthNumberField, int lengthHeaderTerminator, int memoDataOffset, int memoFieldEndMarker, int memoFieldEndMarkerLength, Type[] fieldTypes) {
        this.maxLengthCharField = maxLengthCharField;
        this.maxLengthNumberField = maxLengthNumberField;
        this.lengthHeaderTerminator = lengthHeaderTerminator;
        this.memoDataOffset = memoDataOffset;
        this.memoFieldEndMarker = memoFieldEndMarker;
        this.memoFieldEndMarkerLength = memoFieldEndMarkerLength;
        for (Type type : fieldTypes) {
            this.fieldTypes.add(type);
        }
    }

    int getMaxLengthCharField() {
        return this.maxLengthCharField;
    }

    int getMaxLengthNumberField() {
        return this.maxLengthNumberField;
    }

    int getLengthHeaderTerminator() {
        return this.lengthHeaderTerminator;
    }

    int getMemoDataOffset() {
        return this.memoDataOffset;
    }

    int getMemoFieldEndMarker() {
        return this.memoFieldEndMarker;
    }

    int getMemoFieldEndMarkerLength() {
        return this.memoFieldEndMarkerLength;
    }

    static int getVersionByte(Version version, boolean hasMemo) {
        if (version == DBASE_3 || version == CLIPPER_5) {
            if (hasMemo) {
                return 131;
            }
            return 3;
        }
        if (version == DBASE_4 || version == DBASE_5) {
            if (hasMemo) {
                return 139;
            }
            return 3;
        }
        if (version == FOXPRO_26) {
            if (hasMemo) {
                return 245;
            }
            return 3;
        }
        return 0;
    }

    static Version getVersion(int versionByte, int lengthHeaderTerminator) {
        if (lengthHeaderTerminator == 2) {
            return CLIPPER_5;
        }
        if (versionByte == 131) {
            return DBASE_3;
        }
        if (versionByte == 245) {
            return FOXPRO_26;
        }
        return DBASE_5;
    }
}

