/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import junit.framework.Assert;
import org.apache.jute.BinaryOutputArchive;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class SessionInvalidationTest
extends ClientBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAfterCloseShouldFail() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            boa.writeInt(44, "len");
            ConnectRequest conReq = new ConnectRequest(0, 0L, 30000, 0L, new byte[16]);
            conReq.serialize(boa, "connect");
            boa.writeInt(8, "len");
            RequestHeader h = new RequestHeader(1, -11);
            h.serialize(boa, "header");
            boa.writeInt(52, "len");
            RequestHeader header = new RequestHeader(2, 1);
            header.serialize(boa, "header");
            CreateRequest createReq = new CreateRequest("/foo" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, 1);
            createReq.serialize(boa, "request");
            baos.close();
            System.out.println("Length:" + baos.toByteArray().length);
            String[] hp = this.hostPort.split(":");
            Socket sock = new Socket(hp[0], Integer.parseInt(hp[1]));
            InputStream resultStream = null;
            try {
                int len;
                OutputStream outstream = sock.getOutputStream();
                byte[] data = baos.toByteArray();
                outstream.write(data);
                outstream.flush();
                resultStream = sock.getInputStream();
                byte[] b = new byte[10000];
                while ((len = resultStream.read(b)) >= 0) {
                    System.out.println("gotlen:" + len);
                }
                continue;
            }
            finally {
                if (resultStream != null) {
                    resultStream.close();
                }
                sock.close();
            }
        }
        TestableZooKeeper zk = this.createClient();
        Assert.assertEquals((int)1, (int)zk.getChildren("/", false).size());
        zk.close();
    }
}

