/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectedWatcherTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(DisconnectedWatcherTest.class);
    final int TIMEOUT = 5000;

    @Test
    public void testChildWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1");
        zk2.getChildren("/", true);
        zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        zk2.getChildren("/", childWatcher);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDefaultWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1");
        zk2.getChildren("/", true);
        zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        zk2.getChildren("/", true);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDeepChildWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here/we", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here/we/are", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1/here/we");
        zk2.getChildren("/are", true);
        zk1.create("/ch1/here/we/are/now", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        zk2.getChildren("/are", childWatcher);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/here/we/are/again", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
    }

    @Test
    public void testManyChildWatchersAutoReset() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher);
        String pathBase = "/long-path-000000000-111111111-222222222-333333333-444444444-555555555-666666666-777777777-888888888-999999999";
        zk1.create(pathBase, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            String path = zk1.create(pathBase + "/ch-" + i, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            paths.add(path);
        }
        MyWatcher childWatcher = new MyWatcher();
        int i = 0;
        for (String path : paths) {
            if (i % 3 == 0) {
                zk2.getChildren(path, childWatcher);
            } else if (i % 3 == 1) {
                zk2.exists(path + "/foo", childWatcher);
            } else if (i % 3 == 2) {
                zk2.getData(path, childWatcher, null);
            }
            ++i;
        }
        this.stopServer();
        watcher.waitForDisconnected(30000L);
        this.startServer();
        watcher.waitForConnected(30000L);
        i = 0;
        for (String path : paths) {
            WatchedEvent e;
            if (i % 3 == 0) {
                zk1.create(path + "/ch", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)path, (Object)e.getPath());
            } else if (i % 3 == 1) {
                zk1.create(path + "/foo", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeCreated), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)(path + "/foo"), (Object)e.getPath());
            } else if (i % 3 == 2) {
                zk1.setData(path, new byte[]{1, 2, 3}, -1);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)path, (Object)e.getPath());
            }
            ++i;
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }
}

