/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.impl.GDSServerVersionException;

public final class GDSServerVersion
implements Serializable {
    private static final long serialVersionUID = -3401092369588765195L;
    public static final String TYPE_PRODUCTION = "V";
    public static final String TYPE_BETA = "T";
    public static final String TYPE_DEVELOPMENT = "X";
    public static final GDSServerVersion INVALID_VERSION = new GDSServerVersion("INVALID", "", "", "", 0, 0, 0, 0, "", "");
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\w{2})-(\\w)(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)(-dev)?) ([^-,]+)(?:[-,](.*))?");
    private static final int FULL_VERSION_IDX = 1;
    private static final int PLATFORM_IDX = 2;
    private static final int TYPE_IDX = 3;
    private static final int MAJOR_IDX = 4;
    private static final int MINOR_IDX = 5;
    private static final int VARIANT_IDX = 6;
    private static final int BUILD_IDX = 7;
    private static final int SERVER_NAME_IDX = 9;
    private static final int EXTENDED_INFO_IDX = 10;
    private final String rawStr;
    private final String platform;
    private final String type;
    private final String fullVersion;
    private final int majorVersion;
    private final int minorVersion;
    private final int variant;
    private final int buildNumber;
    private final String serverName;
    private final String extendedServerName;

    private GDSServerVersion(String rawStr, String platform, String type, String fullVersion, int majorVersion, int minorVersion, int variant, int buildNumber, String serverName, String extendedServerName) {
        this.rawStr = rawStr;
        this.platform = platform;
        this.type = type;
        this.fullVersion = fullVersion;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.variant = variant;
        this.buildNumber = buildNumber;
        this.serverName = serverName;
        this.extendedServerName = extendedServerName;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getType() {
        return this.type;
    }

    public int getVariant() {
        return this.variant;
    }

    public String getExtendedServerName() {
        return this.extendedServerName;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public int hashCode() {
        return this.rawStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GDSServerVersion)) {
            return false;
        }
        GDSServerVersion that = (GDSServerVersion)obj;
        return this.rawStr.equals(that.rawStr);
    }

    public String toString() {
        return this.rawStr;
    }

    public static GDSServerVersion parseRawVersion(String versionString) throws GDSServerVersionException {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new GDSServerVersionException(String.format("Version string \"%s\" does not match expected format", versionString));
        }
        return new GDSServerVersion(versionString, matcher.group(2), matcher.group(3), matcher.group(1), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), matcher.group(9), matcher.group(10));
    }

    public boolean isEqualOrAbove(int requiredMajorVersion, int requiredMinorVersion) {
        return this.majorVersion > requiredMajorVersion || this.majorVersion == requiredMajorVersion && this.minorVersion >= requiredMinorVersion;
    }
}

