/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.Activator;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.influxdb.InfluxDB;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class InfluxConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/influxdb_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Text databaseText;
    private Text userText;
    private Text passwordText;
    private Button userSSLCheck;
    private Combo defConsistencyLevel;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite composite) {
        ModifyListener modifyListener = modifyEvent -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gridData);
        new Label(this.settingsGroup, 0).setText("InfluxDB support: beta version");
        Group group = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Server", (int)4, (int)768, (int)-1);
        this.hostText = UIUtils.createLabelText((Composite)group, (String)"Host", (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(modifyListener);
        this.portText = UIUtils.createLabelText((Composite)group, (String)"Port", (String)"");
        gridData = new GridData(2);
        gridData.widthHint = 60;
        this.portText.setLayoutData((Object)gridData);
        this.portText.addModifyListener(modifyListener);
        this.databaseText = UIUtils.createLabelText((Composite)group, (String)"Database", (String)"");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.databaseText.setLayoutData((Object)gridData);
        this.databaseText.addModifyListener(modifyListener);
        group = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Security", (int)4, (int)32, (int)-1);
        this.userText = UIUtils.createLabelText((Composite)group, (String)"User Name", (String)"user", (int)2048);
        gridData = new GridData(32);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.userText.setLayoutData((Object)gridData);
        this.userText.addModifyListener(modifyListener);
        this.passwordText = UIUtils.createLabelText((Composite)group, (String)"Password", (String)"", (int)0x400800);
        gridData = new GridData(32);
        gridData.widthHint = 200;
        this.passwordText.setLayoutData((Object)gridData);
        this.passwordText.addModifyListener(modifyListener);
        this.createSavePasswordButton((Composite)group, 2);
        this.userSSLCheck = UIUtils.createCheckbox((Composite)group, (String)"Use SSL", (String)"Use SSL (HTTPS) protocol", (boolean)false, (int)4);
        group = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Misc", (int)2, (int)768, (int)0);
        this.defConsistencyLevel = UIUtils.createLabelCombo((Composite)group, (String)"Default consistency level", (String)"Default consistencty level for queries", (int)12);
        InfluxDB.ConsistencyLevel[] consistencyLevelArray = InfluxDB.ConsistencyLevel.values();
        int n = consistencyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            InfluxDB.ConsistencyLevel consistencyLevel = consistencyLevelArray[n2];
            this.defConsistencyLevel.add(consistencyLevel.name());
            ++n2;
        }
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty() && !this.userText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration dBPConnectionConfiguration = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getHostPort())) {
                this.portText.setText(String.valueOf(dBPConnectionConfiguration.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getDatabaseName())) {
                this.databaseText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getDatabaseName()));
            } else {
                this.databaseText.setText("");
            }
            if (dBPConnectionConfiguration.getUserName() != null) {
                this.userText.setText(dBPConnectionConfiguration.getUserName());
            }
            if (dBPConnectionConfiguration.getUserPassword() != null) {
                this.passwordText.setText(dBPConnectionConfiguration.getUserPassword());
            }
            this.userSSLCheck.setSelection(CommonUtils.getBoolean((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-influxdb.use.ssl"), (boolean)false));
            String string = CommonUtils.toString((Object)dBPConnectionConfiguration.getProviderProperty("@dbeaver-default.consistency.level@"));
            if (CommonUtils.isEmpty((String)string)) {
                this.defConsistencyLevel.setText(InfluxDB.ConsistencyLevel.ONE.name());
            } else {
                this.defConsistencyLevel.setText(string);
            }
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dBPDataSourceContainer) {
        DBPConnectionConfiguration dBPConnectionConfiguration = dBPDataSourceContainer.getConnectionConfiguration();
        if (this.hostText != null) {
            dBPConnectionConfiguration.setHostName(this.hostText.getText().trim());
            dBPConnectionConfiguration.setHostPort(this.portText.getText().trim());
            dBPConnectionConfiguration.setDatabaseName(this.databaseText.getText().trim());
            dBPConnectionConfiguration.setUserName(this.userText.getText());
            dBPConnectionConfiguration.setUserPassword(this.passwordText.getText());
            dBPConnectionConfiguration.setProviderProperty("@dbeaver-influxdb.use.ssl", String.valueOf(this.userSSLCheck.getSelection()));
            dBPConnectionConfiguration.setProviderProperty("@dbeaver-default.consistency.level@", String.valueOf(this.defConsistencyLevel.getText()));
        }
        super.saveSettings(dBPDataSourceContainer);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[0];
    }
}

