/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;

public class DBVColorOverride {
    private String attributeName;
    private DBCLogicalOperator operator;
    private Object[] attributeValues;
    private String colorForeground;
    private String colorBackground;

    public DBVColorOverride(String attributeName, DBCLogicalOperator operator, Object[] attributeValues, String colorForeground, String colorBackground) {
        this.attributeName = attributeName;
        this.operator = operator;
        this.attributeValues = attributeValues;
        this.colorForeground = colorForeground;
        this.colorBackground = colorBackground;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public DBCLogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DBCLogicalOperator operator) {
        this.operator = operator;
    }

    public Object[] getAttributeValues() {
        return this.attributeValues;
    }

    public void addAttributeValue(Object value) {
        if (this.attributeValues == null) {
            this.attributeValues = new Object[]{value};
        } else {
            Object[] newValue = new Object[this.attributeValues.length + 1];
            System.arraycopy(this.attributeValues, 0, newValue, 0, this.attributeValues.length);
            newValue[newValue.length - 1] = value;
            this.attributeValues = newValue;
        }
    }

    public String getColorForeground() {
        return this.colorForeground;
    }

    public void setColorForeground(String colorForeground) {
        this.colorForeground = colorForeground;
    }

    public String getColorBackground() {
        return this.colorBackground;
    }

    public void setColorBackground(String colorBackground) {
        this.colorBackground = colorBackground;
    }

    public boolean matches(@NotNull String attrName, @NotNull DBCLogicalOperator operator, @Nullable Object[] values) {
        return attrName.equals(this.attributeName) && operator == this.operator && Arrays.equals(this.attributeValues, values);
    }

    public String toString() {
        return String.valueOf(this.attributeName) + " " + this.operator.toString() + " " + Arrays.toString(this.attributeValues);
    }
}

