/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.Array;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCComplexValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCArrayValueHandler
extends JDBCComplexValueHandler {
    public static final JDBCArrayValueHandler INSTANCE = new JDBCArrayValueHandler();

    @NotNull
    public Class<DBDCollection> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBDCollection.class;
    }

    @Override
    public DBDCollection getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return JDBCCollection.makeCollectionFromArray((JDBCSession)session, type, null);
        }
        if (object instanceof JDBCCollection) {
            return (JDBCCollection)(copy ? ((JDBCCollection)object).cloneValue(session.getProgressMonitor()) : object);
        }
        if (object instanceof Array) {
            return JDBCCollection.makeCollectionFromArray((JDBCSession)session, type, (Array)object);
        }
        if (object instanceof String) {
            return JDBCCollection.makeCollectionFromString((JDBCSession)session, (String)object);
        }
        if (object.getClass().isArray()) {
            return JDBCCollection.makeCollectionFromJavaArray((JDBCSession)session, type, object);
        }
        return JDBCCollection.makeCollectionFromString((JDBCSession)session, CommonUtils.toString((Object)object));
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof JDBCCollection) {
            return ((JDBCCollection)value).makeArrayString(format);
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2003);
        } else if (value instanceof DBDCollection) {
            DBDCollection collection = (DBDCollection)value;
            if (collection.isNull()) {
                statement.setNull(paramIndex, 2003);
            } else if (collection instanceof JDBCCollection) {
                statement.setObject(paramIndex, (Object)((JDBCCollection)collection).getArrayValue(), 2003);
            } else {
                statement.setObject(paramIndex, collection.getRawValue());
            }
        } else {
            throw new DBCException("Array parameter type '" + value.getClass().getName() + "' not supported");
        }
    }
}

