/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.widgets.opal.tipoftheday.TipOfTheDay;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.ui.tipoftheday.TipsXmlHandler;
import org.jkiss.utils.CommonUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ShowTipOfTheDayHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ShowTipOfTheDayHandler.class);
    public static final String UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP = "ui.show.tip.of.the.day.on.startup";

    static void showTipOfTheDay(IWorkbenchWindow window) {
        List<String> tips = ShowTipOfTheDayHandler.loadTips();
        if (!CommonUtils.isEmpty(tips)) {
            ShowTipOfTheDayHandler.showTipOfTheDayDialog(tips, window);
        }
    }

    private static void showTipOfTheDayDialog(List<String> tips, IWorkbenchWindow window) {
        TipOfTheDay tipDialog = new TipOfTheDay();
        tipDialog.setDisplayShowOnStartup(true);
        tipDialog.setShowOnStartup(DBeaverCore.getGlobalPreferenceStore().getBoolean(UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP));
        for (String tip : tips) {
            tipDialog.addTip(tip);
        }
        tipDialog.open(window.getShell());
        DBeaverCore.getGlobalPreferenceStore().setValue(UI_SHOW_TIP_OF_THE_DAY_ON_STARTUP, tipDialog.isShowOnStartup());
    }

    private static List<String> loadTips() {
        ArrayList<String> result = new ArrayList<String>();
        String pathToTipsFile = Platform.getProduct().getProperty("tipsFile");
        if (pathToTipsFile == null) {
            return result;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream tipsInputStream = FileLocator.find((URL)new URL(pathToTipsFile)).openConnection().getInputStream();){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                TipsXmlHandler handler = new TipsXmlHandler();
                saxParser.parse(tipsInputStream, (DefaultHandler)handler);
                result.addAll(handler.getTips());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error((Object)"Unable to parse tips file:", (Throwable)e);
        }
        catch (IOException ioe) {
            log.error((Object)"Tips file wasn't found", (Throwable)ioe);
        }
        if (!result.isEmpty() && result.size() > 1) {
            Collections.shuffle(result);
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ShowTipOfTheDayHandler.showTipOfTheDay(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        return null;
    }
}

