/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeCache;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndexColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class PostgreSchema
implements DBSSchema,
DBPNamedObject2,
DBPSaveableObject,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer,
PostgreObject,
PostgreScriptObject {
    private static final Log log = Log.getLog(PostgreSchema.class);
    private final PostgreDatabase database;
    protected long oid;
    protected String name;
    protected String description;
    protected long ownerId;
    protected boolean persisted;
    public final CollationCache collationCache = new CollationCache();
    public final ExtensionCache extensionCache = new ExtensionCache();
    public final TableCache tableCache = new TableCache();
    public final ConstraintCache constraintCache = new ConstraintCache();
    public final ProceduresCache proceduresCache = new ProceduresCache();
    public final IndexCache indexCache = new IndexCache();
    public final PostgreDataTypeCache dataTypeCache = new PostgreDataTypeCache();

    public PostgreSchema(PostgreDatabase database, String name, ResultSet dbResult) throws SQLException {
        this.database = database;
        this.name = name;
        this.loadInfo(dbResult);
    }

    public PostgreSchema(PostgreDatabase database, String name, PostgreRole owner) {
        this.database = database;
        this.name = name;
        this.ownerId = owner == null ? 0L : owner.getObjectId();
    }

    protected void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"nspowner");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.persisted = true;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(order=4)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.database.getRoleById(monitor, this.ownerId);
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostgreDatabase getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Association
    public Collection<PostgreCollation> getCollations(DBRProgressMonitor monitor) throws DBException {
        return this.collationCache.getAllObjects(monitor, this);
    }

    @Association
    public PostgreCollation getCollation(DBRProgressMonitor monitor, long id) throws DBException {
        for (PostgreCollation collation : this.collationCache.getAllObjects(monitor, this)) {
            if (collation.getObjectId() != id) continue;
            return collation;
        }
        log.debug((Object)("Collation '" + id + "' not found in schema " + this.getName()));
        return null;
    }

    @Association
    public Collection<PostgreExtension> getExtensions(DBRProgressMonitor monitor) throws DBException {
        return this.extensionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getObjects(monitor, this, null);
    }

    public PostgreIndex getIndex(DBRProgressMonitor monitor, long indexId) throws DBException {
        for (PostgreIndex index : this.indexCache.getAllObjects(monitor, this)) {
            if (index.getObjectId() != indexId) continue;
            return index;
        }
        return null;
    }

    public PostgreTableBase getTable(DBRProgressMonitor monitor, long tableId) throws DBException {
        for (PostgreClass table : this.tableCache.getAllObjects(monitor, this)) {
            if (table.getObjectId() != tableId) continue;
            return (PostgreTableBase)table;
        }
        return null;
    }

    @Association
    public Collection<? extends JDBCTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, PostgreTable.class).stream().filter(table -> !table.isPartition()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Association
    public Collection<PostgreView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, PostgreView.class);
    }

    @Association
    public Collection<PostgreMaterializedView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, PostgreMaterializedView.class);
    }

    @Association
    public Collection<PostgreSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, PostgreSequence.class);
    }

    @Association
    public PostgreSequence getSequence(DBRProgressMonitor monitor, String name) throws DBException {
        return (PostgreSequence)this.tableCache.getObject(monitor, this, name, PostgreSequence.class);
    }

    @Association
    public Collection<PostgreProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, this);
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, String procName) throws DBException {
        return (PostgreProcedure)this.proceduresCache.getObject(monitor, this, procName);
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long oid) throws DBException {
        for (PostgreProcedure proc : this.proceduresCache.getAllObjects(monitor, this)) {
            if (proc.getObjectId() != oid) continue;
            return proc;
        }
        return null;
    }

    public Collection<? extends JDBCTable> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, PostgreTableReal.class);
    }

    public JDBCTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (JDBCTable)this.tableCache.getObject(monitor, this, childName);
    }

    public Class<? extends DBSEntity> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PostgreTableBase.class;
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        monitor.subTask("Cache tables");
        this.tableCache.getAllObjects(monitor, this);
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache constraints");
            this.constraintCache.getAllObjects(monitor, this);
            this.indexCache.getAllObjects(monitor, this);
        }
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.database.schemaCache.refreshObject(monitor, (DBSObject)this.database, (DBSObject)this);
    }

    public boolean isSystem() {
        return this.isCatalogSchema() || "information_schema".equalsIgnoreCase(this.name) || this.name.startsWith("pg_");
    }

    public boolean isUtility() {
        return PostgreSchema.isUtilitySchema(this.name);
    }

    public boolean isExternal() {
        return false;
    }

    public static boolean isUtilitySchema(String schema) {
        return schema.startsWith("pg_toast") || schema.startsWith("pg_temp_");
    }

    @Association
    public Collection<? extends DBSDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<PostgreDataType> types = new ArrayList<PostgreDataType>();
        for (PostgreDataType dt : this.dataTypeCache.getAllObjects(monitor, this)) {
            if (dt.getParentObject() != this) continue;
            types.add(dt);
        }
        DBUtils.orderObjects(types);
        return types;
    }

    public String toString() {
        return this.name;
    }

    public boolean isCatalogSchema() {
        return "pg_catalog".equals(this.name);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("-- DROP SCHEMA ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(";\n\n");
        sql.append("CREATE SCHEMA ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
        PostgreRole owner = this.getOwner(monitor);
        if (owner != null) {
            sql.append(" AUTHORIZATION ").append(DBUtils.getQuotedIdentifier((DBSObject)owner));
        }
        sql.append(";\n");
        if (!CommonUtils.isEmpty((String)this.getDescription())) {
            sql.append("\nCOMMENT ON SCHEMA ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.getDescription()));
        }
        return sql.toString();
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBException("Schema DDL is read-only");
    }

    class CollationCache
    extends JDBCObjectCache<PostgreSchema, PostgreCollation> {
        CollationCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.oid,c.* FROM pg_catalog.pg_collation c \nWHERE c.collnamespace=?\nORDER BY c.oid");
            dbStat.setLong(1, PostgreSchema.this.getObjectId());
            return dbStat;
        }

        protected PostgreCollation fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCollation(owner, (ResultSet)dbResult);
        }
    }

    class ConstraintCache
    extends JDBCCompositeCache<PostgreSchema, PostgreTableBase, PostgreTableConstraintBase, PostgreTableConstraintColumn> {
        protected ConstraintCache() {
            super((JDBCStructCache)PostgreSchema.this.tableCache, PostgreTableBase.class, (Object)"tabrelname", (Object)"conname");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, PostgreSchema schema, PostgreTableBase forParent) throws SQLException {
            StringBuilder sql = new StringBuilder("SELECT c.oid,c.*,t.relname as tabrelname,rt.relnamespace as refnamespace,d.description\nFROM pg_catalog.pg_constraint c\nINNER JOIN pg_catalog.pg_class t ON t.oid=c.conrelid\nLEFT OUTER JOIN pg_catalog.pg_class rt ON rt.oid=c.confrelid\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=c.oid AND d.objsubid=0\nWHERE ");
            if (forParent == null) {
                sql.append("t.relnamespace=?");
            } else {
                sql.append("c.conrelid=?");
            }
            sql.append("\nORDER BY c.oid");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forParent == null) {
                dbStat.setLong(1, schema.getObjectId());
            } else {
                dbStat.setLong(1, forParent.getObjectId());
            }
            return dbStat;
        }

        @Nullable
        protected PostgreTableConstraintBase fetchObject(JDBCSession session, PostgreSchema schema, PostgreTableBase table, String childName, JDBCResultSet resultSet) throws SQLException, DBException {
            DBSEntityConstraintType constraintType;
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"conname");
            String type = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"contype");
            if (type == null) {
                log.warn((Object)"Null constraint type");
                return null;
            }
            switch (type) {
                case "c": {
                    constraintType = DBSEntityConstraintType.CHECK;
                    break;
                }
                case "f": {
                    constraintType = DBSEntityConstraintType.FOREIGN_KEY;
                    break;
                }
                case "p": {
                    constraintType = DBSEntityConstraintType.PRIMARY_KEY;
                    break;
                }
                case "u": {
                    constraintType = DBSEntityConstraintType.UNIQUE_KEY;
                    break;
                }
                case "t": {
                    constraintType = PostgreConstants.CONSTRAINT_TRIGGER;
                    break;
                }
                case "x": {
                    constraintType = PostgreConstants.CONSTRAINT_EXCLUSIVE;
                    break;
                }
                default: {
                    log.warn((Object)("Unsupported PG constraint type: " + type));
                    return null;
                }
            }
            try {
                if (constraintType == DBSEntityConstraintType.FOREIGN_KEY) {
                    return new PostgreTableForeignKey(table, name, resultSet);
                }
                return new PostgreTableConstraint(table, name, constraintType, resultSet);
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }

        @Nullable
        protected PostgreTableConstraintColumn[] fetchObjectRow(JDBCSession session, PostgreTableBase table, PostgreTableConstraintBase constraint, JDBCResultSet resultSet) throws SQLException, DBException {
            Object keyNumbers = JDBCUtils.safeGetArray((ResultSet)resultSet, (String)"conkey");
            if (keyNumbers == null) {
                return null;
            }
            DBRProgressMonitor monitor = resultSet.getSession().getProgressMonitor();
            if (constraint instanceof PostgreTableForeignKey) {
                PostgreTableForeignKey foreignKey = (PostgreTableForeignKey)constraint;
                PostgreTableBase refTable = foreignKey.getAssociatedEntity();
                if (refTable == null) {
                    log.warn((Object)("Unresolved reference table of '" + foreignKey.getName() + "'"));
                    return null;
                }
                Object keyRefNumbers = JDBCUtils.safeGetArray((ResultSet)resultSet, (String)"confkey");
                Collection attributes = table.getAttributes(monitor);
                Collection refAttributes = refTable.getAttributes(monitor);
                assert (attributes != null && refAttributes != null);
                int colCount = Array.getLength(keyNumbers);
                int refColCount = Array.getLength(keyRefNumbers);
                PostgreTableConstraintColumn[] fkCols = new PostgreTableForeignKeyColumn[colCount];
                int i = 0;
                while (i < colCount) {
                    Number colNumber = (Number)Array.get(keyNumbers, i);
                    if (i >= refColCount) {
                        log.debug((Object)("Number of foreign columns is less than constraint columns (" + refColCount + " < " + colCount + ") in " + constraint.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        break;
                    }
                    Number colRefNumber = (Number)Array.get(keyRefNumbers, i);
                    PostgreTableColumn attr = (PostgreTableColumn)PostgreUtils.getAttributeByNum(attributes, colNumber.intValue());
                    PostgreTableColumn refAttr = (PostgreTableColumn)PostgreUtils.getAttributeByNum(refAttributes, colRefNumber.intValue());
                    if (attr == null) {
                        log.warn((Object)("Bad foreign key attribute index: " + colNumber));
                    } else if (refAttr == null) {
                        log.warn((Object)("Bad reference table '" + refTable + "' attribute index: " + colNumber));
                    } else {
                        PostgreTableForeignKeyColumn cCol = new PostgreTableForeignKeyColumn(foreignKey, attr, i, refAttr);
                        fkCols[i] = cCol;
                    }
                    ++i;
                }
                return fkCols;
            }
            Collection attributes = table.getAttributes(monitor);
            assert (attributes != null);
            int colCount = Array.getLength(keyNumbers);
            PostgreTableConstraintColumn[] cols = new PostgreTableConstraintColumn[colCount];
            int i = 0;
            while (i < colCount) {
                Number colNumber = (Number)Array.get(keyNumbers, i);
                Object attr = PostgreUtils.getAttributeByNum(attributes, colNumber.intValue());
                if (attr == null) {
                    log.warn((Object)("Bad constraint attribute index: " + colNumber));
                } else {
                    PostgreTableConstraintColumn cCol;
                    cols[i] = cCol = new PostgreTableConstraintColumn(constraint, (PostgreAttribute)attr, i);
                }
                ++i;
            }
            return cols;
        }

        protected void cacheChildren(DBRProgressMonitor monitor, PostgreTableConstraintBase object, List<PostgreTableConstraintColumn> children) {
            object.cacheAttributes(monitor, children, false);
        }

        protected void cacheChildren2(DBRProgressMonitor monitor, PostgreTableConstraintBase object, List<PostgreTableConstraintColumn> children) {
            object.cacheAttributes(monitor, children, true);
        }
    }

    class ExtensionCache
    extends JDBCObjectCache<PostgreSchema, PostgreExtension> {
        ExtensionCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT e.oid,e.* FROM pg_catalog.pg_extension e \nWHERE e.extnamespace=?\nORDER BY e.oid");
            dbStat.setLong(1, PostgreSchema.this.getObjectId());
            return dbStat;
        }

        protected PostgreExtension fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreExtension(owner, (ResultSet)dbResult);
        }
    }

    class IndexCache
    extends JDBCCompositeCache<PostgreSchema, PostgreTableBase, PostgreIndex, PostgreIndexColumn> {
        protected IndexCache() {
            super((JDBCStructCache)PostgreSchema.this.tableCache, PostgreTableBase.class, (Object)"tabrelname", (Object)"relname");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, PostgreSchema owner, PostgreTableBase forTable) throws SQLException {
            boolean supportsExprIndex = PostgreSchema.this.getDataSource().isServerVersionAtLeast(7, 4);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT i.*,i.indkey as keys,c.relname,c.relnamespace,c.relam,c.reltablespace,tc.relname as tabrelname,dsc.description");
            if (supportsExprIndex) {
                sql.append(",pg_catalog.pg_get_expr(i.indpred, i.indrelid) as pred_expr");
                sql.append(",pg_catalog.pg_get_expr(i.indexprs, i.indrelid, true) as expr");
            }
            sql.append("\nFROM pg_catalog.pg_index i\nINNER JOIN pg_catalog.pg_class c ON c.oid=i.indexrelid\nINNER JOIN pg_catalog.pg_class tc ON tc.oid=i.indrelid\nLEFT OUTER JOIN pg_catalog.pg_description dsc ON i.indexrelid=dsc.objoid\nWHERE ");
            if (forTable != null) {
                sql.append(" i.indrelid=?");
            } else {
                sql.append(" c.relnamespace=?");
            }
            sql.append(" ORDER BY c.relname");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forTable != null) {
                dbStat.setLong(1, forTable.getObjectId());
            } else {
                dbStat.setLong(1, PostgreSchema.this.getObjectId());
            }
            return dbStat;
        }

        @Nullable
        protected PostgreIndex fetchObject(JDBCSession session, PostgreSchema owner, PostgreTableBase parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreIndex(session.getProgressMonitor(), parent, indexName, (ResultSet)dbResult);
        }

        @Nullable
        protected PostgreIndexColumn[] fetchObjectRow(JDBCSession session, PostgreTableBase parent, PostgreIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
            long[] keyNumbers = PostgreUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"keys"));
            if (keyNumbers == null) {
                return null;
            }
            long[] indColClasses = PostgreUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"indclass"));
            int[] keyOptions = PostgreUtils.getIntVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"indoption"));
            String expr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"expr");
            Collection attributes = parent.getAttributes(dbResult.getSession().getProgressMonitor());
            assert (attributes != null);
            PostgreIndexColumn[] result = new PostgreIndexColumn[keyNumbers.length];
            int i = 0;
            while (i < keyNumbers.length) {
                PostgreIndexColumn col;
                long colNumber = keyNumbers[i];
                String attrExpression = null;
                Object attr = PostgreUtils.getAttributeByNum(attributes, (int)colNumber);
                if (attr == null) {
                    if (colNumber == 0L && expr != null) {
                        attrExpression = JDBCUtils.queryString((JDBCSession)session, (String)"select pg_catalog.pg_get_indexdef(?, ?, true)", (Object[])new Object[]{object.getObjectId(), i + 1});
                    } else {
                        log.warn((Object)("Bad index attribute index: " + colNumber));
                    }
                }
                int options = keyOptions == null || keyOptions.length < keyNumbers.length ? 0 : keyOptions[i];
                long colOpClass = indColClasses == null || indColClasses.length < keyNumbers.length ? 0L : indColClasses[i];
                result[i] = col = new PostgreIndexColumn(object, (PostgreAttribute)attr, attrExpression, i, colOpClass != 0L || (options & 1) != 0, colOpClass, false);
                ++i;
            }
            return result;
        }

        protected void cacheChildren(DBRProgressMonitor monitor, PostgreIndex index, List<PostgreIndexColumn> rows) {
            index.setColumns(rows);
        }
    }

    static class ProceduresCache
    extends JDBCObjectLookupCache<PostgreSchema, PostgreProcedure> {
        ProceduresCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @Nullable PostgreProcedure object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.oid,p.*," + (session.getDataSource().isServerVersionAtLeast(8, 4) ? "pg_catalog.pg_get_expr(p.proargdefaults, 0)" : "NULL") + " as arg_defaults,d.description\n" + "FROM pg_catalog.pg_proc p\n" + "LEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=p.oid\n" + "WHERE p.pronamespace=?" + (object == null ? "" : " AND p.oid=?") + "\nORDER BY p.proname");
            dbStat.setLong(1, owner.getObjectId());
            if (object != null) {
                dbStat.setLong(2, object.getObjectId());
            }
            return dbStat;
        }

        protected PostgreProcedure fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreProcedure(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    public class TableCache
    extends JDBCStructLookupCache<PostgreSchema, PostgreTableBase, PostgreTableColumn> {
        protected TableCache() {
            super((Object)"relname");
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreSchema postgreSchema, @Nullable PostgreTableBase object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.oid,c.*,d.description\nFROM pg_catalog.pg_class c\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=c.oid AND d.objsubid=0\nWHERE c.relnamespace=? AND c.relkind not in ('i','c')" + (object == null && objectName == null ? "" : " AND relname=?"));
            dbStat.setLong(1, PostgreSchema.this.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected PostgreTableBase fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String kindString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind");
            PostgreClass.RelKind kind = PostgreClass.RelKind.valueOf(kindString);
            return owner.getDataSource().getServerType().createRelationOfClass(PostgreSchema.this, kind, dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
            String sql = "SELECT c.relname,a.*,pg_catalog.pg_get_expr(ad.adbin, ad.adrelid, true) as def_value,dsc.description\nFROM pg_catalog.pg_attribute a\nINNER JOIN pg_catalog.pg_class c ON (a.attrelid=c.oid)\nLEFT OUTER JOIN pg_catalog.pg_attrdef ad ON (a.attrelid=ad.adrelid AND a.attnum = ad.adnum)\nLEFT OUTER JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)\nWHERE NOT a.attisdropped AND c.relnamespace=? AND c.relkind not in ('i','c')  ORDER BY a.attnum";
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setLong(1, PostgreSchema.this.getObjectId());
            return dbStat;
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @Nullable PostgreTableBase forTable) throws SQLException {
            if (forTable == null) {
                return this.prepareChildrenStatement(session, owner);
            }
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.relname,a.*,ad.oid as attr_id,pg_catalog.pg_get_expr(ad.adbin, ad.adrelid, true) as def_value,dsc.description\nFROM pg_catalog.pg_attribute a\nINNER JOIN pg_catalog.pg_class c ON (a.attrelid=c.oid)\nLEFT OUTER JOIN pg_catalog.pg_attrdef ad ON (a.attrelid=ad.adrelid AND a.attnum = ad.adnum)\nLEFT OUTER JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)\nWHERE NOT a.attisdropped AND c.oid=? ORDER BY a.attnum");
            dbStat.setLong(1, forTable.getObjectId());
            return dbStat;
        }

        protected PostgreTableColumn fetchChild(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull PostgreTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            try {
                return new PostgreTableColumn(session.getProgressMonitor(), table, dbResult);
            }
            catch (DBException e) {
                log.warn((Object)"Error reading attribute info", (Throwable)e);
                return null;
            }
        }
    }
}

