/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.ArrayUtils;

public class PostgreDialect
extends JDBCSQLDialect {
    public static final String[] POSTGRE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"SHOW", "SET"});

    public PostgreDialect() {
        super("PostgreSQL");
    }

    public void addExtraKeywords(String ... keywords) {
        super.addSQLKeywords(Arrays.asList(keywords));
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.addExtraKeywords("SHOW", "TYPE", "USER", "COMMENT", "MATERIALIZED", "ILIKE", "ELSIF", "ELSEIF", "ANALYSE", "ANALYZE", "CONCURRENTLY", "FREEZE", "LANGUAGE", "MODULE", "OFFSET", "RETURNING", "VARIADIC", "PERFORM", "FOREACH", "LOOP", "PERFORM", "RAISE", "NOTICE", "CONFLICT", "EXTENSION", "DATATYPE", "TABLESPACE", "REFRESH");
        this.addExtraKeywords("CURRENT_DATABASE", "ARRAY_AGG", "BIT_AND", "BIT_OR", "BOOL_AND", "BOOL_OR", "JSON_AGG", "JSONB_AGG", "JSON_OBJECT_AGG", "JSONB_OBJECT_AGG", "STRING_AGG", "XMLAGG", "BIT_LENGTH", "CURRENT_CATALOG", "CURRENT_SCHEMA", "SQLCODE", "LENGTH", "SQLERROR");
        this.addFunctions(Arrays.asList(PostgreConstants.POSTGIS_FUNCTIONS));
        this.removeSQLKeyword("LENGTH");
        if (dataSource instanceof PostgreDataSource) {
            ((PostgreDataSource)dataSource).getServerType().configureDialect(this);
        }
    }

    public int getCatalogUsage() {
        return 0;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public String getBlockToggleString() {
        return "$\\*\\$";
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public String[][] getBlockBoundStrings() {
        return null;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return PostgreBinaryFormatter.INSTANCE;
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        super.loadDataTypesFromDatabase(dataSource);
        this.addDataTypes(PostgreConstants.DATA_TYPE_ALIASES.keySet());
    }

    @NotNull
    protected String[] getNonTransactionKeywords() {
        return POSTGRE_NON_TRANSACTIONAL_KEYWORDS;
    }
}

