/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxStatement;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxFloat
extends IfxObject {
    private double h;

    IfxFloat() throws SQLException {
        this.setIfxType(3);
    }

    IfxFloat(double d2) throws SQLException {
        this.setIfxType(3);
        this.h = d2;
        this.unnullify();
    }

    IfxFloat(Double d2) throws SQLException {
        this.setIfxType(3);
        if (d2 != null) {
            this.h = d2;
            this.unnullify();
        }
    }

    IfxFloat(float f2) throws SQLException {
        this.setIfxType(3);
        this.h = f2;
        this.unnullify();
    }

    IfxFloat(Float f2) throws SQLException {
        this.setIfxType(3);
        if (f2 != null) {
            this.h = f2.floatValue();
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDouble(this.h);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[8];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDouble(this.h);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        block3: {
            block2: {
                boolean bl = true;
                bl = IfxFloat.a(byArray, n, n2);
                if (bl) break block2;
                this.unnullify();
                this.h = IfxToJavaType.IfxToJavaDouble(byArray, n);
                if (IfxStatement.t == 0) break block3;
            }
            this.nullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxFloat) {
            IfxFloat ifxFloat = (IfxFloat)object;
            if (ifxFloat.isNull()) {
                return false;
            }
            return this.h == ifxFloat.h;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.h);
    }

    @Override
    public byte toByte() throws SQLException {
        byte by;
        block3: {
            block2: {
                this.clearWarning();
                if (!this.isNull()) break block2;
                by = 0;
                if (IfxStatement.t == 0) break block3;
            }
            by = (byte)this.h;
        }
        return by;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.h = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = by.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.h;
    }

    @Override
    public void fromDouble(double d2) throws SQLException {
        this.h = d2;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                if (d2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = d2;
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.h;
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.h = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        block3: {
            block2: {
                if (s != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = s.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        int n;
        block3: {
            block2: {
                this.clearWarning();
                if (!this.isNull()) break block2;
                n = 0;
                if (IfxStatement.t == 0) break block3;
            }
            n = (int)this.h;
        }
        return n;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.h = n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        block3: {
            block2: {
                if (n != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = n.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        long l2;
        block3: {
            block2: {
                this.clearWarning();
                if (!this.isNull()) break block2;
                l2 = 0L;
                if (IfxStatement.t == 0) break block3;
            }
            l2 = (long)this.h;
        }
        return l2;
    }

    @Override
    public void fromLong(long l2) throws SQLException {
        this.h = l2;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l2) throws SQLException {
        block3: {
            block2: {
                if (l2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = l2.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        float f2;
        block3: {
            block2: {
                this.clearWarning();
                if (!this.isNull()) break block2;
                f2 = 0.0f;
                if (IfxStatement.t == 0) break block3;
            }
            f2 = (float)this.h;
        }
        return f2;
    }

    @Override
    public void fromFloat(float f2) throws SQLException {
        this.h = f2;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                if (f2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = f2.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.h);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = bigDecimal.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean bl;
        block3: {
            block2: {
                if (!this.isNull()) break block2;
                bl = false;
                if (IfxStatement.t == 0) break block3;
            }
            bl = this.h != 0.0;
        }
        return bl;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.h = bl ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string;
        block3: {
            block2: {
                if (!this.isNull()) break block2;
                string = null;
                if (IfxStatement.t == 0) break block3;
            }
            string = Double.toString(this.h);
        }
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        block5: {
            block4: {
                if (string != null) break block4;
                this.nullify();
                if (IfxStatement.t == 0) break block5;
            }
            try {
                this.h = Double.valueOf(string.trim());
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    static boolean a(double d2) {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d2);
        return IfxFloat.a(byArray);
    }

    static boolean a(byte[] byArray) {
        return IfxFloat.a(byArray, 0, byArray.length);
    }

    static boolean a(byte[] byArray, int n, int n2) {
        byte by;
        block2: {
            int n3 = IfxStatement.t;
            for (int i2 = 0; i2 < 8; ++i2) {
                by = byArray[i2 + n];
                if (n3 == 0) {
                    if (by == -1) continue;
                    return false;
                }
                break block2;
            }
            by = 1;
        }
        return by != 0;
    }

    static double g() {
        double d2;
        block2: {
            int n = IfxStatement.t;
            byte[] byArray = new byte[8];
            double d3 = 0.0;
            for (int i2 = 0; i2 < 8; ++i2) {
                byArray[i2] = -1;
                d2 = IfxToJavaType.IfxToJavaDouble(byArray);
                if (n == 0) {
                    d3 = d2;
                    if (n == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }
}

