/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.core.breakpoints.DatabaseLineBreakpoint;
import org.jkiss.dbeaver.debug.core.breakpoints.IDatabaseBreakpoint;
import org.jkiss.dbeaver.debug.core.model.DatabaseProcess;
import org.jkiss.dbeaver.debug.core.model.DatabaseStackFrame;
import org.jkiss.dbeaver.debug.core.model.DatabaseThread;
import org.jkiss.dbeaver.debug.core.model.DatabaseVariable;
import org.jkiss.dbeaver.debug.core.model.IDatabaseDebugTarget;
import org.jkiss.dbeaver.debug.ui.DBGEditorAdvisor;
import org.jkiss.dbeaver.debug.ui.DebugUI;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;

public class DatabaseDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentationExtension {
    private static Log log = Log.getLog(DatabaseDebugModelPresentation.class);
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final ILabelProvider labelProvider;

    public DatabaseDebugModelPresentation() {
        this(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
    }

    public DatabaseDebugModelPresentation(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public Image getImage(Object element) {
        return this.labelProvider.getImage(element);
    }

    public String getText(Object element) {
        try {
            if (element instanceof IDatabaseDebugTarget) {
                IDatabaseDebugTarget databaseDebugTarget = (IDatabaseDebugTarget)element;
                return databaseDebugTarget.getName();
            }
            if (element instanceof DatabaseProcess) {
                DatabaseProcess process = (DatabaseProcess)element;
                return process.getLabel();
            }
            if (element instanceof DatabaseThread) {
                DatabaseThread thread = (DatabaseThread)element;
                return thread.getName();
            }
            if (element instanceof DatabaseStackFrame) {
                DatabaseStackFrame stackFrame = (DatabaseStackFrame)element;
                return stackFrame.getName();
            }
            if (element instanceof DatabaseVariable) {
                DatabaseVariable variable = (DatabaseVariable)element;
                return variable.getName();
            }
            if (element instanceof DatabaseLineBreakpoint) {
                DatabaseLineBreakpoint breakpoint = (DatabaseLineBreakpoint)element;
                int lineNumber = breakpoint.getLineNumber();
                Object[] bindings = new Object[]{breakpoint.getObjectName(), lineNumber};
                return NLS.bind((String)"{0} - [line:{1}]", (Object[])bindings);
            }
        }
        catch (CoreException coreException) {
            return "<not responding>";
        }
        return this.labelProvider.getText(element);
    }

    public void dispose() {
        this.attributes.clear();
        super.dispose();
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            String valueString = value.getValueString();
            listener.detailComputed(value, valueString);
        }
        catch (DebugException e) {
            String message = NLS.bind((String)"Unable to compute valie for {0}", (Object)value);
            Status status = DebugUtils.newErrorStatus((String)message, (Throwable)e);
            log.log((IStatus)status);
            listener.detailComputed(value, e.getMessage());
        }
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof DBNDatabaseNode) {
            DBNDatabaseNode databaseNode = (DBNDatabaseNode)element;
            return this.createEditorInput(databaseNode);
        }
        if (element instanceof IDatabaseBreakpoint) {
            IDatabaseBreakpoint breakpoint = (IDatabaseBreakpoint)element;
            try {
                String nodePath = breakpoint.getNodePath();
                DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
                DBNNode node = navigatorModel.getNodeByPath((DBRProgressMonitor)new VoidProgressMonitor(), nodePath);
                if (node instanceof DBNDatabaseNode) {
                    DBNDatabaseNode databaseNode = (DBNDatabaseNode)node;
                    return this.createEditorInput(databaseNode);
                }
            }
            catch (Exception e) {
                String message = NLS.bind((String)"Unable to resolve editor input for breakpoint {0}", (Object)breakpoint);
                log.error((Object)message, (Throwable)e);
            }
        }
        return null;
    }

    protected IEditorInput createEditorInput(final DBNDatabaseNode dbnNode) {
        DBGEditorAdvisor editorAdvisor = DebugUI.findEditorAdvisor(dbnNode.getDataSourceContainer());
        final String sourceFolderId = editorAdvisor == null ? null : editorAdvisor.getSourceFolderId();
        final HashMap<String, Boolean> editorAttrs = new HashMap<String, Boolean>();
        editorAttrs.put("debugger.source", true);
        IEditorPart editorPart = (IEditorPart)new UITask<IEditorPart>(){

            protected IEditorPart runTask() {
                return NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)dbnNode, null, (String)sourceFolderId, (Map)editorAttrs, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (boolean)false);
            }
        }.execute();
        return editorPart == null ? null : editorPart.getEditorInput();
    }

    public String getEditorId(IEditorInput input, Object element) {
        return "org.jkiss.dbeaver.ui.editors.entity.EntityEditor";
    }

    public boolean requiresUIThread(Object element) {
        return false;
    }
}

