/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolColumnDataTypeListProvider;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCColumnKeyType;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class ExasolTableColumn
extends JDBCTableColumn<ExasolTableBase>
implements DBSTableColumn,
DBSTypedObjectEx,
DBPHiddenObject,
DBPNamedObject2,
JDBCColumnKeyType {
    private ExasolDataType dataType;
    private Boolean identity;
    private BigDecimal identityValue;
    private String remarks;
    private Boolean isInDistKey;
    private String formatType;
    private Boolean changed = false;
    private Boolean oriRequired;

    public ExasolTableColumn(DBRProgressMonitor monitor, ExasolTableBase tableBase, ResultSet dbResult) throws DBException {
        super((DBSEntity)tableBase, true);
        this.formatType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TYPE");
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION"));
        this.setRequired(!JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"COLUMN_IS_NULLABLE"));
        this.setDefaultValue(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_DEF"));
        this.setMaxLength(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_SIZE"));
        this.setScale(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DECIMAL_DIGITS"));
        this.isInDistKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"COLUMN_IS_DISTRIBUTION_KEY");
        this.identity = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COLUMN_IDENTITY") != null;
        if (this.identity.booleanValue()) {
            this.identityValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"COLUMN_IDENTITY");
        }
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_COMMENT");
        this.dataType = ((ExasolDataSource)tableBase.getDataSource()).getDataType(monitor, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME"));
        this.changed = true;
    }

    public ExasolTableColumn(ExasolTableBase tableBase) {
        super((DBSEntity)tableBase, false);
        this.setMaxLength(50L);
        this.setOrdinalPosition(-1);
        this.dataType = (ExasolDataType)((ExasolDataSource)tableBase.getDataSource()).getDataTypeCache().getCachedObject("VARCHAR");
        this.setTypeName(this.dataType.getFullyQualifiedName(DBPEvaluationContext.DML));
        this.setRequired(false);
        this.setAutoGenerated(false);
        this.setMaxLength(50L);
        this.isInDistKey = false;
        this.identity = false;
        this.remarks = null;
    }

    @NotNull
    public ExasolDataSource getDataSource() {
        return (ExasolDataSource)((ExasolTableBase)this.getTable()).getDataSource();
    }

    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    public String getTypeName() {
        return this.dataType.getName();
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    @Property(viewable=true, editable=false, order=19)
    public ExasolTableBase getOwner() {
        return (ExasolTableBase)this.getTable();
    }

    @Property(viewable=true, editable=true, updatable=true, order=21, listProvider=ExasolColumnDataTypeListProvider.class)
    @Nullable
    public DBSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ExasolDataType dataType) {
        if (!this.dataType.getTypeName().equals(dataType)) {
            this.changed = true;
        }
        this.dataType = dataType;
    }

    @Property(viewable=true, editable=true, updatable=true, order=38)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    public void setMaxLength(long maxLength) {
        if (this.maxLength != maxLength) {
            this.changed = true;
        }
        super.setMaxLength(maxLength);
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=39)
    public Integer getScale() {
        return super.getScale();
    }

    public void setScale(Integer scale) {
        if (!CommonUtils.equalObjects((Object)this.scale, (Object)scale)) {
            this.changed = true;
        }
        super.setScale(scale);
    }

    @Property(viewable=true, editable=true, updatable=true, order=46)
    @Nullable
    public BigDecimal getIdentityValue() {
        return this.identityValue;
    }

    public void setIdentityValue(BigDecimal identityValue) {
        this.identityValue = identityValue;
    }

    @Property(viewable=false, order=40)
    public String getStringLength() {
        return "";
    }

    @Property(viewable=false, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=42)
    public Integer getPrecision() {
        return super.getPrecision();
    }

    public void setPrecision(Integer precision) {
        if (this.precision != precision) {
            this.changed = true;
        }
        this.precision = precision;
        this.precision = precision;
    }

    @Property(viewable=true, order=43, editable=true, updatable=true)
    public boolean isRequired() {
        return super.isRequired();
    }

    public void setRequired(boolean required) {
        if (this.changed.booleanValue() && this.oriRequired == null) {
            this.oriRequired = super.isRequired();
        }
        super.setRequired(required);
    }

    @Property(viewable=true, order=44, editable=true, updatable=true)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
    }

    public void setIdentity(Boolean identity) {
        this.identity = identity;
    }

    @Property(viewable=true, order=999, editable=true, updatable=true, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String remarks) {
        this.remarks = remarks;
    }

    @Property(viewable=true, editable=true, updatable=true, order=121)
    public Boolean isDistKey() {
        return this.isInDistKey;
    }

    public void setDistKey(Boolean distKey) {
        this.isInDistKey = distKey;
    }

    public boolean isHidden() {
        return false;
    }

    @Property(viewable=true, editable=true, updatable=true, order=45)
    public boolean isAutoGenerated() {
        return this.identity;
    }

    public void setAutoGenerated(Boolean identity) {
        this.identity = identity;
    }

    public String getFormatType() {
        block12: {
            if (!this.changed.booleanValue()) break block12;
            switch (this.dataType.getTypeName()) {
                case "CHAR": 
                case "VARCHAR": {
                    this.scale = 0;
                    return String.valueOf(this.dataType.getTypeName()) + "(" + Long.toString(this.maxLength) + ")";
                }
                case "DECIMAL": {
                    return String.valueOf(this.dataType.getTypeName()) + "(" + Long.toString(this.maxLength) + "," + Long.toString(this.scale.intValue()) + ")";
                }
            }
            return this.dataType.getTypeName();
        }
        return this.formatType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Property(viewable=true, order=80)
    public boolean isInUniqueKey() {
        if (((ExasolTableBase)this.getTable()).getClass() == ExasolView.class) {
            return false;
        }
        ExasolTable table = (ExasolTable)this.getTable();
        try {
            ExasolTableUniqueKey key;
            Collection<ExasolTableUniqueKey> uniqueKeysCache = ((ExasolTableBase)table).getConstraints((DBRProgressMonitor)new VoidProgressMonitor());
            if (CommonUtils.isEmpty(uniqueKeysCache)) return false;
            Iterator<ExasolTableUniqueKey> iterator = uniqueKeysCache.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(key = iterator.next()).hasColumn(this));
            return true;
        }
        catch (DBException dBException) {
            return false;
        }
    }

    @Property(hidden=true)
    public Boolean isOriRequired() {
        return this.oriRequired;
    }

    public boolean isInReferenceKey() {
        return false;
    }
}

