/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public class ExasolTable
extends ExasolTableBase
implements DBPRefreshableObject,
DBPNamedObject2,
DBPScriptObject {
    private Boolean hasDistKey;
    private Timestamp lastCommit;
    private long sizeRaw;
    private long sizeCompressed;
    private float deletePercentage;
    private Timestamp createTime;
    private Boolean hasRead = false;
    private long tablecount;
    private static String readAdditionalInfo = "SELECT \t* FROM \t( \tSELECT \t\ttable_schema, \t\ttable_name, \t\ttable_owner, \t\ttable_has_distribution_key, \t\ttable_comment, \t\tdelete_percentage, \t\to.created, \t\to.last_commit, \t\ts.raw_object_size, \t\ts.mem_object_size, \t\ts.object_type \tFROM \t\tEXA_ALL_OBJECTS o \tINNER JOIN EXA_ALL_TABLES T ON \t\to.object_id = t.table_object_id \tINNER JOIN EXA_ALL_OBJECT_SIZES s ON \t\to.object_id = s.object_id \tWHERE \t\to.object_id = %s AND o.object_id = %s AND t.table_object_id = %s UNION ALL \tSELECT \t\tschema_name AS table_schema, \t\tobject_name AS table_name, \t\t'SYS' AS table_owner, \t\tFALSE AS table_has_distribution_key, \t\tobject_comment AS table_comment, \t\t0 AS delete_percentage, \t\tCAST( NULL AS TIMESTAMP) AS created, \t\tCAST( NULL AS TIMESTAMP) AS last_commit, \t\t0 AS raw_object_size, \t\t0 AS mem_object_size, \t\tobject_type \tFROM \t\tSYS.EXA_SYSCAT \tWHERE \t\tobject_type = 'TABLE' \t\tAND schema_name = '%s' \t\tAND object_name = '%s' ) AS o ORDER BY \ttable_schema, \to.table_name";
    private static String count = "select count(*) as COUNTER from %s";

    public ExasolTable(DBRProgressMonitor monitor, ExasolSchema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
    }

    public ExasolTable(ExasolSchema schema, String name) {
        super(schema, name, false);
    }

    private void read(DBRProgressMonitor monitor) throws DBCException {
        JDBCResultSet dbResult;
        Object var8_16;
        Throwable throwable;
        String sql;
        JDBCStatement stmt;
        Object var4_8;
        JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)ExasolMessages.read_table_details);
        try {
            Throwable throwable2 = null;
            var4_8 = null;
            try {
                stmt = session.createStatement();
                try {
                    sql = String.format(readAdditionalInfo, this.getObjectId(), this.getObjectId(), this.getObjectId(), ExasolUtils.quoteString(this.getSchema().getName()), ExasolUtils.quoteString(this.getName()));
                    throwable = null;
                    var8_16 = null;
                    try {
                        dbResult = stmt.executeQuery(sql);
                        try {
                            dbResult.next();
                            this.hasDistKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TABLE_HAS_DISTRIBUTION_KEY");
                            this.lastCommit = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_COMMIT");
                            this.sizeRaw = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RAW_OBJECT_SIZE");
                            this.sizeCompressed = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MEM_OBJECT_SIZE");
                            this.deletePercentage = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"DELETE_PERCENTAGE");
                            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
                        }
                        finally {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
        try {
            Throwable e = null;
            var4_8 = null;
            try {
                stmt = session.createStatement();
                try {
                    sql = String.format(count, this.getFullyQualifiedName(DBPEvaluationContext.DML));
                    throwable = null;
                    var8_16 = null;
                    try {
                        dbResult = stmt.executeQuery(sql);
                        try {
                            dbResult.next();
                            this.tablecount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"COUNTER");
                        }
                        finally {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (e == null) {
                    e = throwable6;
                } else if (e != throwable6) {
                    e.addSuppressed(throwable6);
                }
                throw e;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
        this.hasRead = true;
    }

    @Override
    public void refreshObjectState(DBRProgressMonitor monitor) throws DBCException {
        this.read(monitor);
        super.refreshObjectState(monitor);
    }

    @Property(viewable=true, expensive=false, editable=false, order=90, category="Base Object")
    public Boolean getHasDistKey(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.hasDistKey;
    }

    @Property(viewable=true, expensive=false, editable=false, order=100, category="Base Object")
    public Timestamp getLastCommit(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.lastCommit;
    }

    @Property(viewable=true, expensive=false, editable=false, order=100, category="Date & Time")
    public Timestamp getCreateTime(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.createTime;
    }

    @Property(viewable=true, expensive=false, editable=false, order=150, category="Statistics")
    public String getRawsize(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return ExasolUtils.humanReadableByteCount(this.sizeRaw, true);
    }

    @Property(viewable=true, expensive=false, editable=false, order=200, category="Statistics")
    public String getCompressedsize(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return ExasolUtils.humanReadableByteCount(this.sizeCompressed, true);
    }

    @Property(viewable=true, expensive=false, editable=false, order=250, category="Statistics")
    public float getDeletePercentage(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.deletePercentage;
    }

    @Property(viewable=true, expensive=false, editable=false, order=300, category="Statistics")
    public long getTableCount(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.tablecount;
    }

    @Override
    @Nullable
    @Association
    public Collection<ExasolTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getConstraintCache().getObjects(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public ExasolTableUniqueKey getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (ExasolTableUniqueKey)((ExasolSchema)this.getContainer()).getConstraintCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<ExasolTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getAssociationCache().getObjects(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public DBSTableForeignKey getAssociation(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)((ExasolSchema)this.getContainer()).getAssociationCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, ukName);
    }

    public ExasolTableUniqueKey getPrimaryKey(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.getConstraints(monitor).isEmpty()) {
            return null;
        }
        return this.getConstraints(monitor).iterator().next();
    }

    @Override
    public boolean isView() {
        return false;
    }

    public JDBCStructCache<ExasolSchema, ExasolTable, ExasolTableColumn> getCache() {
        return ((ExasolSchema)this.getContainer()).getTableCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        ((ExasolSchema)this.getContainer()).getTableCache().clearChildrenCache(this);
        ((ExasolSchema)this.getContainer()).getConstraintCache().clearObjectCache(this);
        ((ExasolSchema)this.getContainer()).getAssociationCache().clearObjectCache(this);
        return this;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.generateDDLforTable(monitor, (ExasolDataSource)this.getDataSource(), this);
    }

    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }

    public Collection<ExasolTableColumn> getDistributionKey(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableColumn> distKeyCols = new ArrayList<ExasolTableColumn>();
        for (ExasolTableColumn c : this.getAttributes(monitor)) {
            if (!c.isDistKey().booleanValue()) continue;
            distKeyCols.add(c);
        }
        return distKeyCols;
    }
}

