/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager.security;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolConnectionGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolRoleGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolSchemaGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolScriptGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolSystemGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolTableGrant;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolViewGrant;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class ExasolGrantee
implements DBPSaveableObject,
DBPRefreshableObject {
    private ExasolDataSource dataSource;
    private boolean persisted;

    public ExasolGrantee(ExasolDataSource dataSource, ResultSet resultSet) {
        this.dataSource = dataSource;
        this.persisted = resultSet != null;
    }

    public ExasolGrantee(ExasolDataSource dataSource, Boolean persisted) {
        this.dataSource = dataSource;
        this.persisted = persisted;
    }

    public abstract String getName();

    public boolean isPersisted() {
        return this.persisted;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Collection<ExasolSystemGrant> getSystemgrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSystemGrant> sysGrants = new ArrayList<ExasolSystemGrant>();
        for (ExasolSystemGrant grant : this.dataSource.getSystemGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            sysGrants.add(grant);
        }
        return sysGrants;
    }

    public Collection<ExasolConnectionGrant> getConnections(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolConnectionGrant> conGrants = new ArrayList<ExasolConnectionGrant>();
        for (ExasolConnectionGrant grant : this.dataSource.getConnectionGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            conGrants.add(grant);
        }
        return conGrants;
    }

    public Collection<ExasolRoleGrant> getRoles(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolRoleGrant> roleGrants = new ArrayList<ExasolRoleGrant>();
        for (ExasolRoleGrant grant : this.dataSource.getRoleGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            roleGrants.add(grant);
        }
        return roleGrants;
    }

    public Collection<ExasolTableGrant> getTables(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableGrant> grants = new ArrayList<ExasolTableGrant>();
        for (ExasolTableGrant grant : this.dataSource.getTableGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolViewGrant> getViews(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolViewGrant> grants = new ArrayList<ExasolViewGrant>();
        for (ExasolViewGrant grant : this.dataSource.getViewGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolScriptGrant> getProcedures(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolScriptGrant> grants = new ArrayList<ExasolScriptGrant>();
        for (ExasolScriptGrant grant : this.dataSource.getScriptGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolSchemaGrant> getSchemas(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSchemaGrant> grants = new ArrayList<ExasolSchemaGrant>();
        for (ExasolSchemaGrant grant : this.dataSource.getSchemaGrants(monitor)) {
            if (!grant.getName().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }
}

