/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.editors.json;

import java.util.LinkedList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.ui.UIUtils;

public class JSONScanner
extends RuleBasedScanner {
    public JSONScanner() {
        this.initScanner();
    }

    public void reinitScanner() {
        this.initScanner();
    }

    private void initScanner() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        Color color = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        Color color2 = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        Color color3 = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.number.foreground");
        Token token = new Token((Object)new TextAttribute(color2));
        Token token2 = new Token((Object)new TextAttribute(color3));
        Token token3 = new Token((Object)new TextAttribute(color));
        Token token4 = new Token((Object)new TextAttribute(color));
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new NumberRule((IToken)token2));
        linkedList.add(new MultiLineRule(":\"", "\"", (IToken)token2, '\\'));
        linkedList.add(new MultiLineRule("\"", "\"", (IToken)token, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)token3);
        wordRule.addWord("null", (IToken)token4);
        linkedList.add(wordRule);
        linkedList.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        IRule[] iRuleArray = new IRule[linkedList.size()];
        linkedList.toArray(iRuleArray);
        this.setRules(iRuleArray);
    }

    public static class WhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    public static class WordDetector
    implements IWordDetector {
        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }
}

