/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxSelectStatement;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementField;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class InfluxMeasurement
implements DBSEntity,
DBSDataContainer,
DBSDataManipulator,
DBPRefreshableObject {
    private static final Log log = Log.getLog(InfluxMeasurement.class);
    private final InfluxDatabase database;
    private final String name;
    private final FieldCache fieldCache = new FieldCache();
    private final TagCache tagCache = new TagCache();
    private transient MeasurementKey measurementKey;
    public static final DBSEntityConstraintType TIME_KEY = new DBSEntityConstraintType("time", "TIME KEY", "Time Key", false, true, false);

    protected InfluxMeasurement(InfluxDatabase influxDatabase, String string) {
        this.database = influxDatabase;
        this.name = string;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public InfluxDatabase getDatabase() {
        return this.database;
    }

    public String getDescription() {
        return null;
    }

    public InfluxDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @Association
    public Collection<InfluxMeasurementField> getAttributes(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.getFields(dBRProgressMonitor);
    }

    @Association
    public Collection<InfluxMeasurementField> getFields(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.fieldCache.getAllObjects(dBRProgressMonitor, this);
    }

    @Association
    public Collection<InfluxMeasurementTag> getTags(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.tagCache.getAllObjects(dBRProgressMonitor, this);
    }

    public InfluxMeasurementField getAttribute(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return this.fieldCache.getObject(dBRProgressMonitor, this, string);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        if (this.measurementKey == null) {
            this.measurementKey = new MeasurementKey();
        }
        return Collections.singletonList(this.measurementKey);
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public int getSupportedFeatures() {
        return 458757;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource dBCExecutionSource, @NotNull DBCSession dBCSession, @NotNull DBDDataReceiver dBDDataReceiver, @Nullable DBDDataFilter dBDDataFilter, long l, long l2, long l3) throws DBCException {
        try {
            DBCStatistics dBCStatistics;
            block25: {
                InfluxSession influxSession = (InfluxSession)dBCSession;
                dBCStatistics = new DBCStatistics();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SELECT * FROM ").append(this.getName());
                SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)stringBuilder, null, (DBDDataFilter)dBDDataFilter);
                SQLUtils.appendQueryOrder((DBPDataSource)this.getDataSource(), (StringBuilder)stringBuilder, null, (DBDDataFilter)dBDDataFilter);
                Throwable throwable = null;
                Object var15_14 = null;
                try (InfluxSelectStatement influxSelectStatement = new InfluxSelectStatement(influxSession, this.getDatabase(), stringBuilder.toString());){
                    influxSelectStatement.setStatementSource(dBCExecutionSource);
                    influxSelectStatement.setLimit(l, l2);
                    dBCStatistics.setQueryText(influxSelectStatement.getQueryString());
                    dBCStatistics.addStatementsCount();
                    if (!influxSelectStatement.executeStatement()) break block25;
                    Throwable throwable2 = null;
                    Object var18_19 = null;
                    try (InfluxResultSet influxResultSet = influxSelectStatement.openResultSet();){
                        dBDDataReceiver.fetchStart((DBCSession)influxSession, (DBCResultSet)influxResultSet, l, l2);
                        try {
                            while (influxResultSet.nextRow()) {
                                if (dBCSession.getProgressMonitor().isCanceled()) {
                                    break;
                                }
                                dBDDataReceiver.fetchRow((DBCSession)influxSession, (DBCResultSet)influxResultSet);
                            }
                        }
                        finally {
                            dBDDataReceiver.fetchEnd((DBCSession)influxSession, (DBCResultSet)influxResultSet);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return dBCStatistics;
        }
        catch (Throwable throwable) {
            throw new DBCException(throwable, (DBPDataSource)this.getDataSource());
        }
    }

    public long countData(@NotNull DBCExecutionSource dBCExecutionSource, @NotNull DBCSession dBCSession, @Nullable DBDDataFilter dBDDataFilter, long l) throws DBCException {
        QueryResult queryResult;
        block5: {
            InfluxSession influxSession = (InfluxSession)dBCSession;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT COUNT(*) FROM ").append(this.getName());
            SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)stringBuilder, null, (DBDDataFilter)dBDDataFilter);
            InfluxDB influxDB = influxSession.getInfluxDB();
            queryResult = influxDB.query(new Query(stringBuilder.toString(), this.getDatabase().getName()));
            if (queryResult != null && !CommonUtils.isEmpty((Collection)queryResult.getResults())) break block5;
            return -1L;
        }
        try {
            for (QueryResult.Series series : CommonUtils.safeList((List)((QueryResult.Result)queryResult.getResults().get(0)).getSeries())) {
                for (List list : CommonUtils.safeList((List)series.getValues())) {
                    if (list.size() <= 1) continue;
                    return CommonUtils.toLong(list.get(1));
                }
            }
            throw new DBException("No count results");
        }
        catch (Throwable throwable) {
            throw new DBCException(throwable, (DBPDataSource)this.getDataSource());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession dBCSession, @NotNull DBSAttributeBase[] dBSAttributeBaseArray, @Nullable DBDDataReceiver dBDDataReceiver, @NotNull DBCExecutionSource dBCExecutionSource) throws DBCException {
        throw new DBCException("Not implemented");
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession dBCSession, @NotNull DBSAttributeBase[] dBSAttributeBaseArray, @NotNull DBSAttributeBase[] dBSAttributeBaseArray2, @Nullable DBDDataReceiver dBDDataReceiver, @NotNull DBCExecutionSource dBCExecutionSource) throws DBCException {
        throw new DBCException("Not implemented");
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession dBCSession, @NotNull DBSAttributeBase[] dBSAttributeBaseArray, @NotNull DBCExecutionSource dBCExecutionSource) throws DBCException {
        throw new DBCException("Not implemented");
    }

    public DBCStatistics truncateData(DBCSession dBCSession, DBCExecutionSource dBCExecutionSource) throws DBCException {
        throw new DBCException("Truncate Not implemented");
    }

    private String getAttributeName(DBSAttributeBase dBSAttributeBase) {
        return DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)dBSAttributeBase.getName());
    }

    public DBSObject refreshObject(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        this.fieldCache.clearCache();
        this.tagCache.clearCache();
        return this;
    }

    class FieldCache
    extends AbstractObjectCache<InfluxMeasurement, InfluxMeasurementField> {
        FieldCache() {
        }

        @NotNull
        public Collection<InfluxMeasurementField> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxMeasurement influxMeasurement) throws DBException {
            if (!this.isFullyCached()) {
                InfluxDataSource influxDataSource = influxMeasurement.getDataSource();
                ArrayList<InfluxMeasurementField> arrayList = new ArrayList<InfluxMeasurementField>();
                arrayList.add(new InfluxMeasurementField(influxMeasurement, 0, "time", influxDataSource.getLocalDataType(InfluxDataType.TypeName.TIMESTAMP.getTypeName())));
                InfluxDB influxDB = InfluxMeasurement.this.getDataSource().getDefaultContext(true).getInfluxDB();
                QueryResult queryResult = influxDB.query(new Query("SHOW FIELD KEYS FROM " + influxMeasurement.getName(), influxMeasurement.getDatabase().getName()));
                for (QueryResult.Result result : queryResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List list : CommonUtils.safeList((List)series.getValues())) {
                            InfluxDataType influxDataType;
                            Object var14_14;
                            Object e = list.get(0);
                            Object v0 = var14_14 = list.size() > 1 ? list.get(1) : null;
                            if (var14_14 == null) {
                                influxDataType = influxDataSource.getLocalDataType(InfluxDataType.TypeName.FLOAT.getTypeName());
                            } else {
                                influxDataType = influxDataSource.getLocalDataType(CommonUtils.toString(var14_14));
                                if (influxDataType == null) {
                                    log.error((Object)("Can't find data type '" + var14_14 + "' for field '" + e + "'"));
                                    influxDataType = influxDataSource.getLocalDataType(InfluxDataType.TypeName.UNKNOWN.getTypeName());
                                }
                            }
                            InfluxMeasurementField influxMeasurementField = new InfluxMeasurementField(influxMeasurement, arrayList.size(), CommonUtils.toString(e), influxDataType);
                            arrayList.add(influxMeasurementField);
                        }
                    }
                }
                arrayList.sort(DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurementField getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxMeasurement influxMeasurement, @NotNull String string) throws DBException {
            return (InfluxMeasurementField)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, influxMeasurement), (String)string);
        }
    }

    public class MeasurementKey
    implements DBSEntityConstraint,
    DBSEntityReferrer {
        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return "time_key";
        }

        @Property(viewable=true, editable=true, order=2)
        @NotNull
        public DBSEntityConstraintType getConstraintType() {
            return TIME_KEY;
        }

        public InfluxMeasurement getParentObject() {
            return InfluxMeasurement.this;
        }

        public String getDescription() {
            return null;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return InfluxMeasurement.this.getDataSource();
        }

        public boolean isPersisted() {
            return true;
        }

        public List<FieldColumn> getAttributeReferences(DBRProgressMonitor dBRProgressMonitor) throws DBException {
            InfluxMeasurementField influxMeasurementField = InfluxMeasurement.this.fieldCache.getObject(dBRProgressMonitor, InfluxMeasurement.this, "time");
            return influxMeasurementField == null ? Collections.emptyList() : Collections.singletonList(new FieldColumn(influxMeasurementField));
        }

        public class FieldColumn
        implements DBSObject,
        DBSEntityAttributeRef {
            private final InfluxMeasurementField timeField;

            public FieldColumn(InfluxMeasurementField influxMeasurementField) {
                this.timeField = influxMeasurementField;
            }

            @NotNull
            public DBSEntityAttribute getAttribute() {
                return this.timeField;
            }

            public DBSObject getParentObject() {
                return MeasurementKey.this;
            }

            @NotNull
            public DBPDataSource getDataSource() {
                return MeasurementKey.this.getDataSource();
            }

            @Property(viewable=true, editable=true, order=1)
            @NotNull
            public String getName() {
                return this.timeField.getName();
            }

            public boolean isPersisted() {
                return true;
            }

            public String getDescription() {
                return null;
            }
        }
    }

    class TagCache
    extends AbstractObjectCache<InfluxMeasurement, InfluxMeasurementTag> {
        TagCache() {
        }

        @NotNull
        public Collection<InfluxMeasurementTag> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxMeasurement influxMeasurement) throws DBException {
            if (!this.isFullyCached()) {
                influxMeasurement.getDataSource();
                ArrayList<InfluxMeasurementTag> arrayList = new ArrayList<InfluxMeasurementTag>();
                InfluxDB influxDB = InfluxMeasurement.this.getDataSource().getDefaultContext(true).getInfluxDB();
                QueryResult queryResult = influxDB.query(new Query("SHOW TAG KEYS FROM " + influxMeasurement.getName(), influxMeasurement.getDatabase().getName()));
                for (QueryResult.Result result : queryResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List list : CommonUtils.safeList((List)series.getValues())) {
                            Object e = list.get(0);
                            InfluxMeasurementTag influxMeasurementTag = new InfluxMeasurementTag(influxMeasurement, arrayList.size(), CommonUtils.toString(e));
                            arrayList.add(influxMeasurementTag);
                        }
                    }
                }
                arrayList.sort(DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurementTag getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxMeasurement influxMeasurement, @NotNull String string) throws DBException {
            return (InfluxMeasurementTag)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, influxMeasurement), (String)string);
        }
    }
}

