/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.influxdb.dto.Pong;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class InfluxDataSourceInfo
implements DBPDataSourceInfo {
    private static final Log log = Log.getLog(InfluxDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.influxdb";
    private final InfluxDataSource dataSource;

    public InfluxDataSourceInfo(InfluxDataSource influxDataSource) {
        this.dataSource = influxDataSource;
    }

    public boolean isReadOnlyData() {
        return true;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "InfluxDB";
    }

    public String getDatabaseProductVersion() {
        Pong pong = this.dataSource.getDefaultContext(true).getInfluxDB().ping();
        return pong.getVersion();
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Influx driver bundle 'org.jkiss.bundle.influxdb' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return false;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return true;
    }

    public boolean isDynamicMetadata() {
        return false;
    }

    public boolean supportsMultipleResults() {
        return true;
    }
}

