/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxBaseStatement;
import com.dbeaver.ee.influxdb.exec.InfluxResultSetMetaColumn;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.model.timeseries.TSResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class InfluxResultSet
implements DBCResultSet,
DBRBlockingObject,
TSResultSet {
    private final InfluxBaseStatement statement;
    private QueryResult.Series series;
    private DBCResultSetMetaData metaData;
    private List<Object> curRow;
    private int rowCount = 0;

    public InfluxResultSet(InfluxBaseStatement influxBaseStatement, QueryResult.Series series) {
        this.statement = influxBaseStatement;
        this.series = series;
        if (influxBaseStatement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        influxBaseStatement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public QueryResult.Series getSeries() {
        return this.series;
    }

    public InfluxSession getSession() {
        return this.statement.getSession();
    }

    public InfluxBaseStatement getSourceStatement() {
        return this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int n) throws DBCException {
        this.checkRowFetched();
        return this.curRow.get(n);
    }

    public Object getAttributeValue(String string) throws DBCException {
        this.checkRowFetched();
        return null;
    }

    public DBDValueMeta getAttributeValueMeta(int n) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public List<Object> getCurRow() {
        return this.curRow;
    }

    public boolean nextRow() throws DBCException {
        if (this.series == null) {
            return false;
        }
        List list = this.series.getValues();
        if (CommonUtils.isEmpty((Collection)list) || list.size() <= this.rowCount) {
            return false;
        }
        this.curRow = (List)list.get(this.rowCount);
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int n) throws DBCException {
        return false;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            ArrayList<InfluxResultSetMetaColumn> arrayList = new ArrayList<InfluxResultSetMetaColumn>();
            if (this.series != null) {
                for (String string : this.series.getColumns()) {
                    arrayList.add(new InfluxResultSetMetaColumn(this, arrayList.size(), string, DBPDataKind.STRING));
                }
            }
            this.metaData = new LocalResultSetMeta(arrayList);
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        if (this.series == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.series.getName())) {
            stringBuilder.append(this.series.getName());
        }
        if (!CommonUtils.isEmpty((Map)this.series.getTags())) {
            stringBuilder.append(": ");
            boolean bl = true;
            for (Map.Entry entry : this.series.getTags().entrySet()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                bl = false;
            }
        }
        return stringBuilder.toString();
    }

    public void close() {
        this.statement.getSession().getProgressMonitor().endBlock();
        if (this.statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowCount);
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable Thread thread) throws DBException {
    }
}

