/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class InfluxExecutionContext
extends AbstractExecutionContext<InfluxDataSource> {
    private static final Log log = Log.getLog(InfluxExecutionContext.class);
    private InfluxDB influxDB;
    private InfluxDB.ConsistencyLevel currentConsistencyLevel = InfluxDB.ConsistencyLevel.ONE;

    public InfluxExecutionContext(InfluxDataSource influxDataSource, String string) {
        super((DBPDataSource)influxDataSource, string);
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void connect(DBRProgressMonitor dBRProgressMonitor) throws DBCException {
        this.connect(dBRProgressMonitor, null, null);
    }

    public void connect(DBRProgressMonitor dBRProgressMonitor, Boolean bl, @Nullable Integer n) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        try {
            try {
                dBRProgressMonitor.subTask("Open influx session");
                DBPConnectionConfiguration dBPConnectionConfiguration = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                this.influxDB = InfluxDBFactory.connect((String)dBPConnectionConfiguration.getUrl(), (String)dBPConnectionConfiguration.getUserName(), (String)dBPConnectionConfiguration.getUserPassword());
                this.influxDB.ping();
                String string = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
                if (!CommonUtils.isEmpty((String)string)) {
                    try {
                        this.currentConsistencyLevel = InfluxDB.ConsistencyLevel.valueOf((String)string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug((Object)("Bad default consistency level: " + string));
                    }
                }
                this.influxDB.setConsistency(this.currentConsistencyLevel);
                super.initContextBootstrap(dBRProgressMonitor, true);
                ((InfluxDataSource)this.dataSource).addExecutionContext(this);
            }
            catch (Exception exception) {
                throw new DBCException((Throwable)exception, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public InfluxSession openSession(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull DBCExecutionPurpose dBCExecutionPurpose, @NotNull String string) {
        return new InfluxSession(dBRProgressMonitor, dBCExecutionPurpose, string, this);
    }

    public void checkContextAlive(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        try {
            Pong pong = this.influxDB.ping();
            pong.getVersion();
        }
        catch (Exception exception) {
            throw new DBException("Error pinging Influx", (Throwable)exception);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor dBRProgressMonitor, boolean bl) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.influxDB.close();
        InfluxExecutionContext influxExecutionContext = this;
        synchronized (influxExecutionContext) {
            ((InfluxDataSource)this.dataSource).removeExecutionContext(this);
            super.closeContext();
        }
    }

    public InfluxDB.ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(InfluxDB.ConsistencyLevel consistencyLevel) {
        this.currentConsistencyLevel = consistencyLevel;
        this.influxDB.setConsistency(this.currentConsistencyLevel);
    }
}

