/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

public class HexConverts {
    public static final int[] HEX_INTS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    private HexConverts() {
    }

    public static String hexConvert(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(HEX_DIGITS.charAt((byArray[i] & 0xF0) >> 4));
            stringBuffer.append(HEX_DIGITS.charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String hexConvert(byte[] byArray) {
        return HexConverts.hexConvert(byArray, byArray.length);
    }

    public static byte[] hexConvertToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            byArray[i] = (byte)n2;
        }
        return byArray;
    }

    public static String binaryConvert(long l, int n) {
        String string = Long.toBinaryString(l);
        int n2 = n * 8 - string.length();
        if (n2 < 0) {
            throw new IllegalArgumentException("The value translates to more than the specified number of digits");
        }
        while (n2-- > 0) {
            string = "0" + string;
        }
        return string;
    }

    public static String hexConvert(long l, int n) {
        String string = Long.toHexString(l).toUpperCase();
        int n2 = n * 2 - string.length();
        if (n2 < 0) {
            if (string.regionMatches(0, "FFFFFFFFFFFFFFFF", 0, -n2)) {
                string = string.substring(-n2, string.length());
            } else {
                throw new IllegalArgumentException("The value translates to more than the specified number of digits");
            }
        }
        while (n2-- > 0) {
            string = "0" + string;
        }
        return string;
    }

    public static String hexConvert(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        int n3 = n2 * 2 - string.length();
        if (n3 < 0) {
            if (string.regionMatches(0, "FFFFFFFFFFFFFFFF", 0, -n3)) {
                string = string.substring(-n3, string.length());
            } else {
                throw new IllegalArgumentException("The value translates to more than the specified number of digits");
            }
        }
        while (n3-- > 0) {
            string = "0" + string;
        }
        return string;
    }
}

