/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class RotatingButton
extends Canvas {
    private int mouse = 0;
    private boolean hit = false;
    private String text = "Button";
    float rotatingAngle = 0.0f;
    float[] angles = new float[]{0.0f, 90.0f, 180.0f, 270.0f};
    int index = 0;

    public RotatingButton(Composite parent, int style) {
        super(parent, style);
        this.addListener(4, e -> {
            ++this.index;
            this.index = this.index > 3 ? 0 : this.index;
            Rectangle r = this.getBounds();
            this.setBounds(r.x, r.y, r.height, r.width);
            this.rotatingAngle = this.angles[this.index];
            this.redraw();
        });
        this.addPaintListener(this::paint);
        this.addMouseMoveListener(e -> {
            if (!this.hit) {
                return;
            }
            this.mouse = 2;
            if (e.x < 0 || e.y < 0 || e.x > this.getBounds().width || e.y > this.getBounds().height) {
                this.mouse = 0;
            }
            this.redraw();
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                RotatingButton.this.mouse = 1;
                RotatingButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                RotatingButton.this.mouse = 0;
                RotatingButton.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RotatingButton.this.hit = true;
                RotatingButton.this.mouse = 2;
                RotatingButton.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                RotatingButton.this.hit = false;
                RotatingButton.this.mouse = 1;
                if (e.x < 0 || e.y < 0 || e.x > RotatingButton.this.getBounds().width || e.y > RotatingButton.this.getBounds().height) {
                    RotatingButton.this.mouse = 0;
                }
                RotatingButton.this.redraw();
                if (RotatingButton.this.mouse == 1) {
                    RotatingButton.this.notifyListeners(13, new Event());
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.character == ' ') {
                    Event event = new Event();
                    RotatingButton.this.notifyListeners(13, event);
                }
            }
        });
    }

    public void setText(String string) {
        this.text = string;
        this.redraw();
    }

    public void paint(PaintEvent e) {
        Transform tr = new Transform((Device)e.display);
        Rectangle r = this.getBounds();
        this.text = "" + e.gc.stringExtent(this.text);
        e.gc.setAntialias(1);
        Point p = e.gc.stringExtent(this.text);
        int w = e.width;
        int h = e.height;
        tr.translate((float)(w / 2), (float)(h / 2));
        tr.rotate(this.rotatingAngle);
        e.gc.setTransform(tr);
        e.gc.drawString(this.text, r.x - p.x / 3 * 2, r.y - p.y);
    }
}

