/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.plan;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.ui.views.plan.PlanNodesTree;
import org.jkiss.utils.CommonUtils;

public class ExplainPlanViewer
implements IPropertyChangeListener {
    private SashForm planPanel;
    private Text sqlText;
    private PlanNodesTree planTree;
    private PropertyTreeViewer planProperties;
    private DBCExecutionContext executionContext;
    private SQLQuery query;
    private DBCQueryPlanner planner;
    private RefreshPlanAction refreshPlanAction;
    private ToggleViewAction toggleViewAction;
    private final SashForm leftPanel;
    private transient Object selectedElement;

    public ExplainPlanViewer(IWorkbenchPart workbenchPart, Composite parent) {
        this.createActions();
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.planPanel = UIUtils.createPartDivider((IWorkbenchPart)workbenchPart, (Composite)composite, (int)256);
        this.planPanel.setLayoutData((Object)new GridData(1808));
        this.planPanel.setBackground(parent.getDisplay().getSystemColor(22));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.planPanel.setLayout((Layout)gl);
        this.leftPanel = UIUtils.createPartDivider((IWorkbenchPart)workbenchPart, (Composite)this.planPanel, (int)512);
        this.leftPanel.setLayoutData((Object)new GridData(1808));
        this.planTree = new PlanNodesTree((Composite)this.leftPanel, 0x10000000, (IWorkbenchSite)workbenchPart.getSite()){

            @Override
            public void fillCustomActions(IContributionManager contributionManager) {
                contributionManager.add((IAction)ExplainPlanViewer.this.toggleViewAction);
                contributionManager.add((IAction)ExplainPlanViewer.this.refreshPlanAction);
            }
        };
        this.planTree.setShowDivider(true);
        this.planTree.createProgressPanel(composite);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        this.planTree.setLayoutData(gd);
        this.sqlText = new Text((Composite)this.leftPanel, 2634);
        this.leftPanel.setWeights(new int[]{80, 20});
        this.planProperties = new PropertyTreeViewer((Composite)this.planPanel, 768);
        this.planPanel.setWeights(new int[]{70, 30});
        this.planTree.getControl().addPaintListener(e -> {
            String message = null;
            if (this.planner == null) {
                message = "No connection or data source doesn't support execution plan";
            } else if (CommonUtils.isEmpty((String)this.sqlText.getText())) {
                message = "Select a query and run " + ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.explain", (IServiceLocator)workbenchPart.getSite(), (boolean)false);
            }
            if (message != null) {
                Rectangle bounds = this.planTree.getBounds();
                Point ext = e.gc.textExtent(message);
                e.gc.drawText(message, (bounds.width - ext.x) / 2, bounds.height / 3 + 20);
            }
        });
        this.planTree.getItemsViewer().addSelectionChangedListener(event -> this.showPlanNode());
        this.planTree.getControl().addTraverseListener(e -> {
            if (this.toggleViewAction.isEnabled() && (e.detail == 16 || e.detail == 8)) {
                this.toggleViewAction.run();
                e.doit = false;
                e.detail = 0;
            }
        });
    }

    public SQLQuery getQuery() {
        return this.query;
    }

    private void showPlanNode() {
        Object element;
        ISelection selection = this.planTree.getItemsViewer().getSelection();
        if (selection.isEmpty()) {
            this.planProperties.clearProperties();
        } else if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != this.selectedElement) {
            PropertyCollector propertySource = new PropertyCollector(element, true);
            propertySource.collectProperties();
            this.planProperties.loadProperties((DBPPropertySource)propertySource);
            this.selectedElement = element;
        }
    }

    private void createActions() {
        this.toggleViewAction = new ToggleViewAction();
        this.toggleViewAction.setEnabled(false);
        this.refreshPlanAction = new RefreshPlanAction();
        this.refreshPlanAction.setEnabled(false);
    }

    public Control getControl() {
        return this.planPanel.getParent();
    }

    public Viewer getViewer() {
        return this.planTree.getItemsViewer();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void explainQueryPlan(DBCExecutionContext executionContext, SQLQuery query) throws DBCException {
        this.executionContext = executionContext;
        this.query = query;
        if (this.executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            this.planner = (DBCQueryPlanner)DBUtils.getAdapter(DBCQueryPlanner.class, (Object)dataSource);
        } else {
            this.planner = null;
        }
        this.planTree.clearListData();
        this.refreshPlanAction.setEnabled(false);
        if (this.planner == null) {
            throw new DBCException("This datasource doesn't support execution plans");
        }
        if (this.planTree.isLoading()) {
            UIUtils.showMessageBox((Shell)this.getControl().getShell(), (String)"Can't explain plan", (String)"Explain plan already running", (int)1);
            return;
        }
        this.sqlText.setText(query.getText());
        this.planTree.init(this.executionContext, this.planner, query.getText());
        this.planTree.loadData();
        this.refreshPlanAction.setEnabled(true);
        this.toggleViewAction.setEnabled(true);
    }

    private class RefreshPlanAction
    extends Action {
        private RefreshPlanAction() {
            super("Reevaluate", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH));
        }

        public void run() {
            if (ExplainPlanViewer.this.planTree != null) {
                ExplainPlanViewer.this.planTree.loadData();
            }
        }
    }

    private class ToggleViewAction
    extends Action {
        private ToggleViewAction() {
            super("View Source", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_TEXT));
        }

        public void run() {
            Control maxControl = ExplainPlanViewer.this.leftPanel.getMaximizedControl();
            if (maxControl == null) {
                ExplainPlanViewer.this.leftPanel.setMaximizedControl((Control)ExplainPlanViewer.this.planTree);
            } else {
                ExplainPlanViewer.this.leftPanel.setMaximizedControl(null);
            }
        }
    }
}

