/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLScriptBindingType;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLResources
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.resources";
    private static final Log log = Log.getLog(PrefPageSQLResources.class);
    private Combo deleteEmptyCombo;
    private Button autoFoldersCheck;
    private Button connectionFoldersCheck;
    private Text scriptTitlePattern;
    private Button bindEmbeddedReadCheck;
    private Button bindEmbeddedWriteCheck;
    private Composite commentTypeComposite;
    private ControlEnableState commentTypeEnableBlock;
    private SQLScriptBindingType curScriptBindingType;

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group connGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_connection_association, (int)2, (int)768, (int)0);
        Label tipLabel = new Label((Composite)connGroup, 64);
        tipLabel.setText(CoreMessages.pref_page_sql_editor_checkbox_bind_connection_hint);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        tipLabel.setLayoutData((Object)gd);
        this.bindEmbeddedReadCheck = UIUtils.createCheckbox((Composite)connGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_bind_embedded_read, (String)CoreMessages.pref_page_sql_editor_checkbox_bind_embedded_read_tip, (boolean)false, (int)2);
        this.bindEmbeddedWriteCheck = UIUtils.createCheckbox((Composite)connGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_bind_embedded_write, (String)CoreMessages.pref_page_sql_editor_checkbox_bind_embedded_write_tip, (boolean)false, (int)2);
        this.bindEmbeddedWriteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLResources.this.enableCommentType();
            }
        });
        this.commentTypeComposite = UIUtils.createComposite((Composite)connGroup, (int)1);
        SQLScriptBindingType[] sQLScriptBindingTypeArray = SQLScriptBindingType.values();
        int n = sQLScriptBindingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLScriptBindingType bt = sQLScriptBindingTypeArray[n2];
            if (bt != SQLScriptBindingType.EXTERNAL) {
                UIUtils.createRadioButton((Composite)this.commentTypeComposite, (String)bt.getDescription(), (Object)((Object)bt), (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                    this.curScriptBindingType = (SQLScriptBindingType)((Object)((Object)selectionEvent.widget.getData()));
                }));
            }
            ++n2;
        }
        Group scriptsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_resources, (int)2, (int)768, (int)0);
        this.deleteEmptyCombo = UIUtils.createLabelCombo((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_delete_empty_scripts, (int)12);
        SQLPreferenceConstants.EmptyScriptCloseBehavior[] emptyScriptCloseBehaviorArray = SQLPreferenceConstants.EmptyScriptCloseBehavior.values();
        int n3 = emptyScriptCloseBehaviorArray.length;
        int n4 = 0;
        while (n4 < n3) {
            SQLPreferenceConstants.EmptyScriptCloseBehavior escb = emptyScriptCloseBehaviorArray[n4];
            this.deleteEmptyCombo.add(escb.getTitle());
            ++n4;
        }
        this.deleteEmptyCombo.setLayoutData((Object)new GridData(32));
        this.deleteEmptyCombo.select(0);
        this.autoFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_put_new_scripts, null, (boolean)false, (int)2);
        this.connectionFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_create_script_folders, null, (boolean)false, (int)2);
        this.scriptTitlePattern = UIUtils.createLabelText((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_title_pattern, (String)"");
        UIUtils.installContentProposal((Control)this.scriptTitlePattern, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"connectionName"), GeneralUtils.variablePattern((String)"driverName"), GeneralUtils.variablePattern((String)"fileName"), GeneralUtils.variablePattern((String)"fileExt")}));
        UIUtils.setContentProposalToolTip((Control)this.scriptTitlePattern, (String)"Output file name patterns", (String[])new String[]{"connectionName", "driverName", "fileName", "fileExt"});
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.bindEmbeddedReadCheck.setSelection(store.getBoolean("SQLEditor.script.bind.embedded.read"));
        this.bindEmbeddedWriteCheck.setSelection(store.getBoolean("SQLEditor.script.bind.embedded.write"));
        try {
            SQLScriptBindingType bindingType = SQLScriptBindingType.valueOf(store.getString("SQLEditor.script.bind.commentType"));
            Control[] controlArray = this.commentTypeComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ch = controlArray[n2];
                if (ch instanceof Button && ch.getData() == bindingType) {
                    ((Button)ch).setSelection(true);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
        }
        this.enableCommentType();
        this.deleteEmptyCombo.setText(SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(store.getString("script.delete.empty")).getTitle());
        this.autoFoldersCheck.setSelection(store.getBoolean("script.auto.folders"));
        this.connectionFoldersCheck.setSelection(store.getBoolean("script.auto.connection.folders"));
        this.scriptTitlePattern.setText(store.getString("script.title.pattern"));
        super.performDefaults();
    }

    private void enableCommentType() {
        if (this.bindEmbeddedWriteCheck.getSelection()) {
            if (this.commentTypeEnableBlock != null) {
                this.commentTypeEnableBlock.restore();
                this.commentTypeEnableBlock = null;
            }
        } else if (this.commentTypeEnableBlock == null) {
            this.commentTypeEnableBlock = ControlEnableState.disable((Control)this.commentTypeComposite);
        }
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("SQLEditor.script.bind.embedded.read", this.bindEmbeddedReadCheck.getSelection());
        store.setValue("SQLEditor.script.bind.embedded.write", this.bindEmbeddedWriteCheck.getSelection());
        try {
            Control[] controlArray = this.commentTypeComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ch = controlArray[n2];
                if (ch instanceof Button && ((Button)ch).getSelection()) {
                    store.setValue("SQLEditor.script.bind.commentType", ch.getData().toString());
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
        }
        store.setValue("script.delete.empty", SQLPreferenceConstants.EmptyScriptCloseBehavior.getByTitle(this.deleteEmptyCombo.getText()).name());
        store.setValue("script.auto.folders", this.autoFoldersCheck.getSelection());
        store.setValue("script.auto.connection.folders", this.connectionFoldersCheck.getSelection());
        store.setValue("script.title.pattern", this.scriptTitlePattern.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

