/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageMetaData
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.meta";
    private Button readExpensiveCheck;
    private Button separateMetaConnectionCheck;
    private Button caseSensitiveNamesCheck;
    private Button serverSideFiltersCheck;
    private Button ignoreColumnLabelCheck;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.props.expensive") || store.contains("database.meta.separate.connection") || store.contains("database.meta.casesensitive") || store.contains("database.meta.server.side.filters") || store.contains("resultset.column.label.ignore");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group metadataGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_metadata, (int)1, (int)32, (int)0);
        this.separateMetaConnectionCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_separate_meta_connection, (String)CoreMessages.pref_page_database_general_separate_meta_connection_tip, (boolean)false, (int)1);
        this.caseSensitiveNamesCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_checkbox_case_sensitive_names, (String)CoreMessages.pref_page_database_general_checkbox_case_sensitive_names_tip, (boolean)false, (int)1);
        this.readExpensiveCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_checkbox_show_row_count, (String)CoreMessages.pref_page_database_general_checkbox_show_row_count_tip, (boolean)false, (int)1);
        this.serverSideFiltersCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_server_side_object_filters, (String)CoreMessages.pref_page_database_general_server_side_object_filters_tip, (boolean)false, (int)1);
        Group queriesGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_query_metadata, (int)1, (int)32, (int)0);
        this.ignoreColumnLabelCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_general_use_column_names, (String)CoreMessages.pref_page_database_general_use_column_names_tip, (boolean)false, (int)1);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.readExpensiveCheck.setSelection(store.getBoolean("database.props.expensive"));
            this.separateMetaConnectionCheck.setSelection(store.getBoolean("database.meta.separate.connection"));
            this.caseSensitiveNamesCheck.setSelection(store.getBoolean("database.meta.casesensitive"));
            this.serverSideFiltersCheck.setSelection(store.getBoolean("database.meta.server.side.filters"));
            this.ignoreColumnLabelCheck.setSelection(store.getBoolean("resultset.column.label.ignore"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.props.expensive", this.readExpensiveCheck.getSelection());
            store.setValue("database.meta.separate.connection", this.separateMetaConnectionCheck.getSelection());
            store.setValue("database.meta.casesensitive", this.caseSensitiveNamesCheck.getSelection());
            store.setValue("database.meta.server.side.filters", this.serverSideFiltersCheck.getSelection());
            store.setValue("resultset.column.label.ignore", this.ignoreColumnLabelCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.props.expensive");
        store.setToDefault("database.meta.separate.connection");
        store.setToDefault("database.meta.casesensitive");
        store.setToDefault("database.meta.server.side.filters");
        store.setToDefault("resultset.column.label.ignore");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

