/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.registry.maven.MavenRegistry;
import org.jkiss.dbeaver.registry.maven.MavenRepository;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageDriversMaven
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.drivers.maven";
    private Table mavenRepoTable;
    private Text idText;
    private Text nameText;
    private Text urlText;
    private Text scopeText;
    private Text userNameText;
    private Text userPasswordText;
    private final Set<MavenRepository> disabledRepositories = new HashSet<MavenRepository>();
    private Button disableButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Color enabledColor;
    private Color disabledColor;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.enabledColor = parent.getForeground();
        this.disabledColor = parent.getDisplay().getSystemColor(17);
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group mavenGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_drivers_maven_group_repositories, (int)2, (int)1808, (int)300);
        this.mavenRepoTable = new Table((Composite)mavenGroup, 67584);
        UIUtils.createTableColumn((Table)this.mavenRepoTable, (int)16384, (String)"Id");
        UIUtils.createTableColumn((Table)this.mavenRepoTable, (int)16384, (String)"URL");
        this.mavenRepoTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        this.mavenRepoTable.setLayoutData((Object)gd);
        Composite buttonsPH = UIUtils.createPlaceholder((Composite)mavenGroup, (int)1);
        buttonsPH.setLayoutData((Object)new GridData(2));
        UIUtils.createToolButton((Composite)buttonsPH, (String)CoreMessages.pref_page_drivers_maven_button_add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String urlString = EnterNameDialog.chooseName((Shell)PrefPageDriversMaven.this.getShell(), (String)CoreMessages.pref_page_drivers_maven_label_enter_maven_repository_url, (String)"http://");
                if (urlString != null) {
                    try {
                        URL url = new URL(urlString);
                        MavenRepository repository = new MavenRepository(url.getHost(), url.getHost(), url.toString(), MavenRepository.RepositoryType.CUSTOM);
                        TableItem item = new TableItem(PrefPageDriversMaven.this.mavenRepoTable, 0);
                        item.setText(new String[]{url.getHost(), urlString});
                        item.setData((Object)repository);
                    }
                    catch (MalformedURLException e1) {
                        DBUserInterface.getInstance().showError(CoreMessages.pref_page_drivers_maven_label_bad_url, CoreMessages.pref_page_drivers_maven_label_bad_url_tip, (Throwable)e1);
                    }
                }
            }
        });
        this.removeButton = UIUtils.createToolButton((Composite)buttonsPH, (String)CoreMessages.pref_page_drivers_maven_button_remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDriversMaven.this.mavenRepoTable.remove(PrefPageDriversMaven.this.mavenRepoTable.getSelectionIndices());
                PrefPageDriversMaven.this.mavenRepoTable.notifyListeners(13, new Event());
            }
        });
        this.removeButton.setEnabled(false);
        this.disableButton = UIUtils.createToolButton((Composite)buttonsPH, (String)CoreMessages.pref_page_drivers_maven_label_disable, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = PrefPageDriversMaven.this.mavenRepoTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    MavenRepository repo = (MavenRepository)item.getData();
                    if (!PrefPageDriversMaven.this.disabledRepositories.remove(repo)) {
                        PrefPageDriversMaven.this.disabledRepositories.add(repo);
                        item.setForeground(PrefPageDriversMaven.this.disabledColor);
                    } else {
                        item.setForeground(PrefPageDriversMaven.this.enabledColor);
                    }
                    ++n2;
                }
                PrefPageDriversMaven.this.mavenRepoTable.notifyListeners(13, new Event());
            }
        });
        this.removeButton.setEnabled(false);
        this.moveUpButton = UIUtils.createToolButton((Composite)buttonsPH, (String)CoreMessages.pref_page_drivers_maven_button_up, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = PrefPageDriversMaven.this.mavenRepoTable.getSelection()[0];
                int index = PrefPageDriversMaven.this.mavenRepoTable.indexOf(item);
                if (index > 0) {
                    TableItem prevItem = PrefPageDriversMaven.this.mavenRepoTable.getItem(index - 1);
                    PrefPageDriversMaven.this.switchItems(item, prevItem);
                    PrefPageDriversMaven.this.mavenRepoTable.setSelection(index - 1);
                    PrefPageDriversMaven.this.updateSelection();
                }
            }
        });
        this.moveDownButton = UIUtils.createToolButton((Composite)buttonsPH, (String)CoreMessages.pref_page_drivers_maven_button_down, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = PrefPageDriversMaven.this.mavenRepoTable.getSelection()[0];
                int index = PrefPageDriversMaven.this.mavenRepoTable.indexOf(item);
                if (index < PrefPageDriversMaven.this.mavenRepoTable.getItemCount() - 1) {
                    TableItem nextItem = PrefPageDriversMaven.this.mavenRepoTable.getItem(index + 1);
                    PrefPageDriversMaven.this.switchItems(item, nextItem);
                    PrefPageDriversMaven.this.mavenRepoTable.setSelection(index + 1);
                    PrefPageDriversMaven.this.updateSelection();
                }
            }
        });
        this.mavenRepoTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDriversMaven.this.updateSelection();
            }
        });
        Group propsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_drivers_maven_group_properties, (int)2, (int)768, (int)0);
        this.idText = UIUtils.createLabelText((Composite)propsGroup, (String)"ID", (String)"", (int)2056);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().setId(PrefPageDriversMaven.this.idText.getText());
                    PrefPageDriversMaven.this.mavenRepoTable.getSelection()[0].setText(0, PrefPageDriversMaven.this.idText.getText());
                }
            }
        });
        this.nameText = UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.pref_page_drivers_maven_label_name, (String)"", (int)2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().setName(PrefPageDriversMaven.this.nameText.getText());
                }
            }
        });
        this.urlText = UIUtils.createLabelText((Composite)propsGroup, (String)"URL", (String)"", (int)2048);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().setUrl(PrefPageDriversMaven.this.urlText.getText());
                    PrefPageDriversMaven.this.mavenRepoTable.getSelection()[0].setText(1, PrefPageDriversMaven.this.urlText.getText());
                }
            }
        });
        this.scopeText = UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.pref_page_drivers_maven_label_scope, (String)"", (int)2048);
        this.scopeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().setScopes(CommonUtils.splitString((String)PrefPageDriversMaven.this.scopeText.getText(), (char)','));
                }
            }
        });
        Group authGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_drivers_maven_group_authentication, (int)4, (int)768, (int)0);
        this.userNameText = UIUtils.createLabelText((Composite)authGroup, (String)CoreMessages.pref_page_drivers_maven_label_user, (String)"", (int)2048);
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().getAuthInfo().setUserName(PrefPageDriversMaven.this.userNameText.getText());
                }
            }
        });
        this.userPasswordText = UIUtils.createLabelText((Composite)authGroup, (String)CoreMessages.pref_page_drivers_maven_label_password, (String)"", (int)0x400800);
        this.userPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrefPageDriversMaven.this.getSelectedRepository() != null) {
                    PrefPageDriversMaven.this.getSelectedRepository().getAuthInfo().setUserPassword(PrefPageDriversMaven.this.userPasswordText.getText());
                }
            }
        });
        this.performDefaults();
        return composite;
    }

    private void switchItems(TableItem item1, TableItem item2) {
        String id1 = item1.getText(0);
        String url1 = item1.getText(1);
        Object repo1 = item1.getData();
        item1.setText(0, item2.getText(0));
        item1.setText(1, item2.getText(1));
        item1.setData(item2.getData());
        item2.setText(0, id1);
        item2.setText(1, url1);
        item2.setData(repo1);
    }

    private MavenRepository getSelectedRepository() {
        TableItem[] selection = this.mavenRepoTable.getSelection();
        if (selection.length == 1) {
            return (MavenRepository)selection[0].getData();
        }
        return null;
    }

    private void updateSelection() {
        MavenRepository repo = this.getSelectedRepository();
        if (repo != null) {
            if (this.disabledRepositories.contains(repo)) {
                this.disableButton.setText(CoreMessages.pref_page_drivers_maven_label_enable);
            } else {
                this.disableButton.setText(CoreMessages.pref_page_drivers_maven_label_disable);
            }
            this.disableButton.setEnabled(true);
            boolean isEditable = repo.getType() == MavenRepository.RepositoryType.CUSTOM;
            this.removeButton.setEnabled(isEditable);
            this.idText.setEnabled(true);
            this.idText.setEditable(isEditable);
            this.idText.setText(repo.getId());
            this.nameText.setEnabled(true);
            this.nameText.setEditable(isEditable);
            this.nameText.setText(repo.getName());
            this.urlText.setEnabled(true);
            this.urlText.setEditable(isEditable);
            this.urlText.setText(repo.getUrl());
            this.scopeText.setEnabled(true);
            this.scopeText.setEditable(isEditable);
            this.scopeText.setText(CommonUtils.makeString(repo.getScopes(), (char)','));
            this.userNameText.setEnabled(true);
            this.userNameText.setText(CommonUtils.notEmpty((String)repo.getAuthInfo().getUserName()));
            this.userPasswordText.setEnabled(true);
            this.userPasswordText.setText(CommonUtils.notEmpty((String)repo.getAuthInfo().getUserPassword()));
        } else {
            this.disableButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.idText.setEnabled(false);
            this.nameText.setEnabled(false);
            this.urlText.setEnabled(false);
            this.scopeText.setEnabled(false);
            this.userNameText.setEnabled(false);
            this.userPasswordText.setEnabled(false);
        }
        this.moveUpButton.setEnabled(this.mavenRepoTable.getSelectionIndex() > 0);
        this.moveDownButton.setEnabled(this.mavenRepoTable.getSelectionIndex() < this.mavenRepoTable.getItemCount() - 1);
    }

    protected void performDefaults() {
        for (MavenRepository repo : MavenRegistry.getInstance().getRepositories()) {
            MavenRepository repoCopy = repo.getType() == MavenRepository.RepositoryType.CUSTOM ? new MavenRepository(repo) : repo;
            TableItem item = new TableItem(this.mavenRepoTable, 0);
            item.setText(new String[]{repoCopy.getId(), repoCopy.getUrl()});
            item.setData((Object)repoCopy);
            if (repo.isEnabled()) continue;
            this.disabledRepositories.add(repo);
            item.setForeground(this.disabledColor);
        }
        UIUtils.packColumns((Table)this.mavenRepoTable, (boolean)true);
        this.updateSelection();
        super.performDefaults();
    }

    public boolean performOk() {
        ArrayList<MavenRepository> customRepos = new ArrayList<MavenRepository>();
        TableItem[] items = this.mavenRepoTable.getItems();
        int i = 0;
        while (i < items.length) {
            MavenRepository repo;
            TableItem item = items[i];
            repo.setEnabled(!this.disabledRepositories.contains(repo = (MavenRepository)item.getData()));
            repo.setOrder(i);
            if (repo.getType() == MavenRepository.RepositoryType.CUSTOM) {
                customRepos.add(repo);
            }
            ++i;
        }
        MavenRegistry registry = MavenRegistry.getInstance();
        registry.setCustomRepositories(customRepos);
        registry.saveConfiguration();
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

