/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageConfirmations
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.confirmations";
    private Map<String, Combo> confirmChecks = new HashMap<String, Combo>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Composite filterSettings = UIUtils.createPlaceholder((Composite)composite, (int)1, (int)5);
        Group groupObjects = UIUtils.createControlGroup((Composite)filterSettings, (String)CoreMessages.pref_page_confirmations_group_general_actions, (int)2, (int)770, (int)0);
        this.createConfirmCheckbox((Composite)groupObjects, "exit");
        this.createConfirmCheckbox((Composite)groupObjects, "order_resultset");
        this.createConfirmCheckbox((Composite)groupObjects, "close_resultset_edit");
        this.createConfirmCheckbox((Composite)groupObjects, "fetch_all_rows");
        this.createConfirmCheckbox((Composite)groupObjects, "disconnect_txn");
        this.createConfirmCheckbox((Composite)groupObjects, "driver_download");
        this.createConfirmCheckbox((Composite)groupObjects, "version_check");
        groupObjects = UIUtils.createControlGroup((Composite)filterSettings, (String)CoreMessages.pref_page_confirmations_group_object_editor, (int)2, (int)770, (int)0);
        this.createConfirmCheckbox((Composite)groupObjects, "close_entity_edit");
        this.createConfirmCheckbox((Composite)groupObjects, "entity_delete");
        this.createConfirmCheckbox((Composite)groupObjects, "entity_reject");
        this.createConfirmCheckbox((Composite)groupObjects, "entity_revert");
        this.createConfirmCheckbox((Composite)groupObjects, "keep_statement_open");
        this.createConfirmCheckbox((Composite)groupObjects, "dangerous_sql");
        this.createConfirmCheckbox((Composite)groupObjects, "mass_parallel_sql");
        this.createConfirmCheckbox((Composite)groupObjects, "close_editor_edit");
        this.createConfirmCheckbox((Composite)groupObjects, "close_running_query");
        this.performDefaults();
        return composite;
    }

    private void createConfirmCheckbox(Composite parent, String id) {
        ResourceBundle bundle = DBeaverActivator.getCoreResourceBundle();
        String labelKey = ConfirmationDialog.getResourceKey(id, "title");
        UIUtils.createControlLabel((Composite)parent, (String)bundle.getString(labelKey));
        Combo combo = new Combo(parent, 12);
        combo.setItems(new String[]{CoreMessages.pref_page_confirmations_combo_always, CoreMessages.pref_page_confirmations_combo_never, CoreMessages.pref_page_confirmations_combo_prompt});
        this.confirmChecks.put(id, combo);
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        for (Map.Entry<String, Combo> entry : this.confirmChecks.entrySet()) {
            String id = entry.getKey();
            String value = store.getString("org.jkiss.dbeaver.core.confirm." + id);
            if ("always".equals(value)) {
                entry.getValue().select(0);
                continue;
            }
            if ("never".equals(value)) {
                entry.getValue().select(1);
                continue;
            }
            entry.getValue().select(2);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        for (Map.Entry<String, Combo> entry : this.confirmChecks.entrySet()) {
            String id = entry.getKey();
            int selectionIndex = entry.getValue().getSelectionIndex();
            if (selectionIndex == 2) {
                store.setToDefault("org.jkiss.dbeaver.core.confirm." + id);
                continue;
            }
            store.setValue("org.jkiss.dbeaver.core.confirm." + id, selectionIndex == 0 ? "always" : "never");
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }
}

