/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordDetector;

public class SQLIdentifierDetector
extends SQLWordDetector {
    private char structSeparator;
    @NotNull
    private final String[][] quoteStrings;

    public SQLIdentifierDetector(char structSeparator, @Nullable String[][] quoteStrings) {
        this.structSeparator = structSeparator;
        this.quoteStrings = quoteStrings != null ? quoteStrings : new String[][]{};
    }

    protected boolean isQuote(char c) {
        int i = 0;
        while (i < this.quoteStrings.length) {
            if (this.quoteStrings[i][0].indexOf(c) != -1 || this.quoteStrings[i][1].indexOf(c) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsSeparator(String identifier) {
        return identifier.indexOf(this.structSeparator) != -1;
    }

    public String[] splitIdentifier(String identifier) {
        return SQLUtils.splitFullIdentifier((String)identifier, (char)this.structSeparator, (String[][])this.quoteStrings);
    }

    @Override
    public boolean isWordPart(char c) {
        return super.isWordPart(c) || this.isQuote(c) || this.structSeparator == c;
    }

    public boolean isPlainWordPart(char c) {
        return super.isWordPart(c);
    }

    public boolean isQuoted(String token) {
        int i = 0;
        while (i < this.quoteStrings.length) {
            if (token.startsWith(this.quoteStrings[i][0])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String removeQuotes(String name) {
        int i = 0;
        while (i < this.quoteStrings.length) {
            name = DBUtils.getUnQuotedIdentifier((String)name, (String)this.quoteStrings[i][0], (String)this.quoteStrings[i][1]);
            ++i;
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WordRegion detectIdentifier(IDocument document, IRegion region) {
        WordRegion id = new WordRegion(region.getOffset());
        int docLength = document.getLength();
        try {
            char ch;
            if (!this.isPlainWordPart(document.getChar(region.getOffset()))) {
                return id;
            }
            while (id.identStart >= 0 && this.isWordPart(ch = document.getChar(id.identStart))) {
                if (id.wordStart < 0 && !this.isPlainWordPart(ch)) {
                    id.wordStart = id.identStart + 1;
                }
                --id.identStart;
            }
            ++id.identStart;
            while (id.identEnd < docLength && this.isWordPart(ch = document.getChar(id.identEnd))) {
                if (!this.isPlainWordPart(ch)) {
                    id.wordEnd = id.identEnd;
                }
                ++id.identEnd;
            }
            id.extract(document);
            return id;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return id;
    }

    public static class WordRegion {
        public int identStart;
        public int identEnd;
        public int wordStart = -1;
        public int wordEnd = -1;
        public String identifier = "";
        public String word = "";

        WordRegion(int offset) {
            this.identStart = offset;
            this.identEnd = offset;
        }

        void extract(IDocument document) throws BadLocationException {
            if (this.wordStart < 0) {
                this.wordStart = this.identStart;
            }
            if (this.wordEnd < 0) {
                this.wordEnd = this.identEnd;
            }
            this.identifier = document.get(this.identStart, this.identEnd - this.identStart);
            this.word = document.get(this.wordStart, this.wordEnd - this.wordStart);
        }

        public boolean isEmpty() {
            return this.word.isEmpty();
        }
    }
}

