/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.AbstractContextDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.utils.CommonUtils;

public class SQLPresentationPanelDescriptor
extends AbstractContextDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final boolean isSingleton;
    private final boolean isAutoActivate;

    public SQLPresentationPanelDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.isSingleton = CommonUtils.getBoolean((String)config.getAttribute("singleton"), (boolean)true);
        this.isAutoActivate = CommonUtils.getBoolean((String)config.getAttribute("autoActivate"), (boolean)true);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    public SQLEditorPresentationPanel createPanel() throws DBException {
        return (SQLEditorPresentationPanel)this.implClass.createInstance(SQLEditorPresentationPanel.class);
    }
}

