/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorInput;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorNested;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;

public class SQLSourceViewer<T extends DBPScriptObject & DBSObject>
extends SQLEditorNested<T> {
    private IAction OPEN_CONSOLE_ACTION = new Action("Open in SQL console", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

        public void run() {
            DBPDataSource dataSource = SQLSourceViewer.this.getDataSource();
            OpenHandler.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), dataSource == null ? null : dataSource.getContainer(), "Source", SQLSourceViewer.this.getDocument().get());
        }
    };

    @Override
    protected String getSourceText(DBRProgressMonitor monitor) throws DBException {
        return ((DBPScriptObject)this.getSourceObject()).getObjectDefinitionText(monitor, this.getSourceOptions());
    }

    protected Map<String, Object> getSourceOptions() {
        IEditorInput editorInput = this.getEditorInput();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (editorInput instanceof IDatabaseEditorInput) {
            Collection<String> attributeNames = ((IDatabaseEditorInput)editorInput).getAttributeNames();
            options.put("ddl.source", true);
            if (!attributeNames.isEmpty()) {
                for (String name : attributeNames) {
                    Object attribute = ((IDatabaseEditorInput)editorInput).getAttribute(name);
                    options.put(name, attribute);
                }
            }
        }
        return options;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
    }

    @Override
    protected void contributeEditorCommands(IContributionManager toolBarManager) {
        super.contributeEditorCommands(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.OPEN_CONSOLE_ACTION);
    }
}

