/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class ProgressEditorPart
extends EditorPart {
    private final IDatabaseEditor entityEditor;
    private Composite parentControl;
    private Canvas progressCanvas;

    public ProgressEditorPart(IDatabaseEditor entityEditor) {
        this.entityEditor = entityEditor;
    }

    public DatabaseLazyEditorInput getEditorInput() {
        return (DatabaseLazyEditorInput)super.getEditorInput();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.createProgressPane(parent);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.parentControl.setFocus();
    }

    public void setPartName(String newName) {
        super.setPartName(newName);
    }

    public void dispose() {
        super.dispose();
        this.parentControl = null;
    }

    private void createProgressPane(Composite parent) {
        this.progressCanvas = new Canvas(parent, 0);
        this.progressCanvas.addPaintListener(e -> e.gc.drawText("Connecting to datasource '" + this.getEditorInput().getDatabaseObject().getName() + "'...", 5, 5, true));
        InitNodeService loadingService = new InitNodeService();
        LoadingJob loadJob = LoadingJob.createService(loadingService, new InitNodeVisualizer(loadingService));
        loadJob.schedule();
    }

    private void initEntityEditor(IDatabaseEditorInput result) {
        if (result == null) {
            return;
        }
        try {
            this.entityEditor.init(this.entityEditor.getEditorSite(), result);
            this.entityEditor.recreateEditorControl();
        }
        catch (Exception e) {
            DBUserInterface.getInstance().showError("Editor init", "Can't initialize editor", (Throwable)e);
        }
    }

    public Composite destroyAndReturnParent() {
        Composite parent = this.progressCanvas.getParent();
        this.progressCanvas.dispose();
        return parent;
    }

    private class InitNodeService
    extends AbstractLoadService<IDatabaseEditorInput> {
        protected InitNodeService() {
            super("Initialize entity editor");
        }

        public IDatabaseEditorInput evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                return ProgressEditorPart.this.getEditorInput().initializeRealInput(monitor);
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public Object getFamily() {
            return null;
        }
    }

    private class InitNodeVisualizer
    extends ProgressLoaderVisualizer<IDatabaseEditorInput> {
        public InitNodeVisualizer(InitNodeService loadingService) {
            super((ILoadService)loadingService, (Composite)ProgressEditorPart.this.progressCanvas);
        }

        public void completeLoading(IDatabaseEditorInput result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
            ProgressEditorPart.this.initEntityEditor(result);
            if (result == null) {
                UIUtils.asyncExec(() -> {
                    boolean bl = ProgressEditorPart.this.entityEditor.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)ProgressEditorPart.this.entityEditor, false);
                });
            } else {
                UIUtils.asyncExec(() -> DBeaverUI.getInstance().refreshPartContexts((IWorkbenchPart)ProgressEditorPart.this.entityEditor));
            }
        }
    }
}

