/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.utils.CommonUtils;

public class DatabaseEditorInputFactory
implements IElementFactory {
    private static final Log log = Log.getLog(DatabaseEditorInputFactory.class);
    public static final String ID_FACTORY = DatabaseEditorInputFactory.class.getName();
    private static final String TAG_CLASS = "class";
    private static final String TAG_DATA_SOURCE = "data-source";
    private static final String TAG_NODE = "node";
    private static final String TAG_NODE_NAME = "node-name";
    private static final String TAG_ACTIVE_PAGE = "page";
    private static final String TAG_ACTIVE_FOLDER = "folder";
    private static volatile boolean lookupEditor;

    public static void setLookupEditor(boolean lookupEditor) {
        DatabaseEditorInputFactory.lookupEditor = lookupEditor;
    }

    public IAdaptable createElement(IMemento memento) {
        String inputClass = memento.getString(TAG_CLASS);
        String nodePath = memento.getString(TAG_NODE);
        String nodeName = memento.getString(TAG_NODE_NAME);
        String dataSourceId = memento.getString(TAG_DATA_SOURCE);
        if (nodePath == null || inputClass == null || dataSourceId == null) {
            log.error((Object)"Corrupted memento");
            return null;
        }
        String activePageId = memento.getString(TAG_ACTIVE_PAGE);
        String activeFolderId = memento.getString(TAG_ACTIVE_FOLDER);
        DBPDataSourceContainer dataSourceContainer = DataSourceRegistry.findDataSource(dataSourceId);
        if (dataSourceContainer == null) {
            log.error((Object)("Can't find data source '" + dataSourceId + "'"));
            return null;
        }
        if (lookupEditor && !dataSourceContainer.isConnected()) {
            return null;
        }
        IProject project = dataSourceContainer.getRegistry().getProject();
        DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
        navigatorModel.ensureProjectLoaded(project);
        return new DatabaseLazyEditorInput(dataSourceContainer, project, nodePath, nodeName, activePageId, activeFolderId);
    }

    public static void saveState(IMemento memento, DatabaseEditorInput input) {
        if (!DBeaverCore.getGlobalPreferenceStore().getBoolean("ui.editors.reopen-after-restart")) {
            return;
        }
        DBCExecutionContext context = input.getExecutionContext();
        if (context == null) {
            return;
        }
        if (input.getDatabaseObject() != null && !input.getDatabaseObject().isPersisted()) {
            return;
        }
        Object node = input.getNavigatorNode();
        memento.putString(TAG_CLASS, input.getClass().getName());
        memento.putString(TAG_DATA_SOURCE, context.getDataSource().getContainer().getId());
        memento.putString(TAG_NODE, node.getNodeItemPath());
        memento.putString(TAG_NODE_NAME, node.getNodeName());
        if (!CommonUtils.isEmpty((String)input.getDefaultPageId())) {
            memento.putString(TAG_ACTIVE_PAGE, input.getDefaultPageId());
        }
        if (!CommonUtils.isEmpty((String)input.getDefaultFolderId())) {
            memento.putString(TAG_ACTIVE_FOLDER, input.getDefaultFolderId());
        }
    }
}

