/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.BitInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.NumberInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.data.DefaultValueViewDialog;

public class NumericValueManager
extends BaseValueManager {
    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    @Nullable
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: 
            case PANEL: {
                if (controller.getValueType().getDataKind() == DBPDataKind.BOOLEAN) {
                    return new BitInlineEditor(controller);
                }
                return new NumberInlineEditor(controller);
            }
            case EDITOR: {
                return new DefaultValueViewDialog(controller);
            }
        }
        return null;
    }
}

