/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.data.DefaultValueViewDialog;
import org.jkiss.utils.CommonUtils;

public abstract class EnumValueManager
extends BaseValueManager {
    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: {
                if (this.isMultiValue(controller)) {
                    return null;
                }
                return new EnumInlineEditor(controller);
            }
            case PANEL: {
                return new EnumPanelEditor(controller);
            }
            case EDITOR: {
                return new DefaultValueViewDialog(controller);
            }
        }
        return null;
    }

    protected abstract boolean isMultiValue(IValueController var1);

    protected abstract List<String> getEnumValues(IValueController var1);

    protected abstract List<String> getSetValues(IValueController var1, Object var2);

    void fillSetList(IValueController valueController, org.eclipse.swt.widgets.List editor, Object value) {
        editor.removeAll();
        List<String> enumValues = this.getEnumValues(valueController);
        List<String> setValues = this.getSetValues(valueController, value);
        if (enumValues != null) {
            int[] selIndices = new int[setValues.size()];
            int selIndex = 0;
            int i = 0;
            while (i < enumValues.size()) {
                String enumValue = enumValues.get(i);
                editor.add(enumValue);
                if (setValues.contains(enumValue)) {
                    selIndices[selIndex++] = i;
                }
                ++i;
            }
            editor.select(selIndices);
        } else if (editor.getItemCount() == 0) {
            editor.add(CommonUtils.toString((Object)value));
        }
    }

    private class EnumInlineEditor
    extends BaseValueEditor<Combo> {
        private final IValueController controller;

        public EnumInlineEditor(IValueController controller) {
            super(controller);
            this.controller = controller;
            this.setAutoSaveEnabled(true);
        }

        @Override
        public void primeEditorValue(@Nullable Object value) throws DBException {
            ((Combo)this.control).setText(DBUtils.isNullValue((Object)value) ? "" : DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI));
        }

        @Override
        public Object extractEditorValue() {
            int selIndex = ((Combo)this.control).getSelectionIndex();
            if (selIndex < 0) {
                return null;
            }
            return ((Combo)this.control).getItem(selIndex);
        }

        @Override
        protected Combo createControl(Composite editPlaceholder) {
            Combo editor = new Combo(this.controller.getEditPlaceholder(), 8);
            List<String> enumValues = EnumValueManager.this.getEnumValues(this.valueController);
            if (enumValues != null) {
                for (String enumValue : enumValues) {
                    editor.add(enumValue);
                }
            }
            if (editor.getSelectionIndex() < 0) {
                editor.select(0);
            }
            editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnumInlineEditor.this.saveValue();
                }
            });
            return editor;
        }
    }

    private class EnumPanelEditor
    extends BaseValueEditor<org.eclipse.swt.widgets.List> {
        private final IValueController controller;

        public EnumPanelEditor(IValueController controller) {
            super(controller);
            this.controller = controller;
        }

        @Override
        public void primeEditorValue(@Nullable Object value) throws DBException {
            if (EnumValueManager.this.isMultiValue(this.valueController)) {
                EnumValueManager.this.fillSetList(this.valueController, (org.eclipse.swt.widgets.List)this.control, value);
            } else {
                int itemCount;
                if (value == null) {
                    ((org.eclipse.swt.widgets.List)this.control).setSelection(-1);
                }
                if ((itemCount = ((org.eclipse.swt.widgets.List)this.control).getItemCount()) == 0) {
                    if (!DBUtils.isNullValue((Object)value)) {
                        ((org.eclipse.swt.widgets.List)this.control).add(CommonUtils.toString((Object)value));
                    }
                } else {
                    int i = 0;
                    while (i < itemCount) {
                        if (((org.eclipse.swt.widgets.List)this.control).getItem(i).equals(value)) {
                            ((org.eclipse.swt.widgets.List)this.control).setSelection(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public Object extractEditorValue() {
            if (EnumValueManager.this.isMultiValue(this.valueController)) {
                StringBuilder setString = new StringBuilder();
                String[] stringArray = ((org.eclipse.swt.widgets.List)this.control).getSelection();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String sel = stringArray[n2];
                    if (setString.length() > 0) {
                        setString.append(',');
                    }
                    setString.append(sel);
                    ++n2;
                }
                return setString.toString();
            }
            int selIndex = ((org.eclipse.swt.widgets.List)this.control).getSelectionIndex();
            if (selIndex < 0) {
                return null;
            }
            return ((org.eclipse.swt.widgets.List)this.control).getItem(selIndex);
        }

        @Override
        protected org.eclipse.swt.widgets.List createControl(Composite editPlaceholder) {
            int style = 2568;
            style = EnumValueManager.this.isMultiValue(this.valueController) ? (style |= 2) : (style |= 4);
            org.eclipse.swt.widgets.List editor = new org.eclipse.swt.widgets.List(editPlaceholder, style);
            List<String> enumValues = EnumValueManager.this.getEnumValues(this.valueController);
            if (enumValues != null) {
                for (String ev : enumValues) {
                    editor.add(ev);
                }
            }
            if (editor.getSelectionIndex() < 0) {
                editor.select(0);
            }
            if (this.controller.getEditType() == IValueController.EditType.INLINE) {
                editor.setFocus();
            }
            return editor;
        }
    }
}

