/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSConstraintEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.data.DatabaseDataEditor;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ReferenceValueEditor {
    private static final Log log = Log.getLog(ReferenceValueEditor.class);
    private IValueController valueController;
    private IValueEditor valueEditor;
    private DBSEntityReferrer refConstraint;
    private Table editorSelector;
    private volatile boolean sortByValue = true;
    private volatile boolean sortAsc = true;
    private Object lastPattern;

    public ReferenceValueEditor(IValueController valueController, IValueEditor valueEditor) {
        this.valueController = valueController;
        this.valueEditor = valueEditor;
    }

    public boolean isReferenceValue() {
        return this.getEnumerableConstraint() != null;
    }

    @Nullable
    private DBSEntityReferrer getEnumerableConstraint() {
        if (this.valueController instanceof IAttributeController) {
            return ReferenceValueEditor.getEnumerableConstraint(((IAttributeController)this.valueController).getBinding());
        }
        return null;
    }

    public static DBSEntityReferrer getEnumerableConstraint(DBDAttributeBinding binding) {
        try {
            DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
            if (entityAttribute != null) {
                DBSConstraintEnumerable refConstraint;
                DBSEntityReferrer constraint;
                List refs = DBUtils.getAttributeReferrers((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAttribute)entityAttribute);
                DBSEntityReferrer dBSEntityReferrer = constraint = refs.isEmpty() ? null : (DBSEntityReferrer)refs.get(0);
                if (constraint instanceof DBSEntityAssociation && ((DBSEntityAssociation)constraint).getReferencedConstraint() instanceof DBSConstraintEnumerable && (refConstraint = (DBSConstraintEnumerable)((DBSEntityAssociation)constraint).getReferencedConstraint()) != null && refConstraint.supportsEnumeration()) {
                    return constraint;
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return null;
    }

    public boolean createEditorSelector(final Composite parent) {
        DBSEntityAssociation association;
        if (!(this.valueController instanceof IAttributeController) || this.valueController.isReadOnly()) {
            return false;
        }
        this.refConstraint = this.getEnumerableConstraint();
        if (this.refConstraint == null) {
            return false;
        }
        if (this.refConstraint instanceof DBSEntityAssociation && (association = (DBSEntityAssociation)this.refConstraint).getReferencedConstraint() != null) {
            final DBSEntity refTable = association.getReferencedConstraint().getParentObject();
            Composite labelGroup = UIUtils.createPlaceholder((Composite)parent, (int)2);
            labelGroup.setLayoutData((Object)new GridData(768));
            Link dictLabel = UIUtils.createLink((Composite)labelGroup, (String)NLS.bind((String)CoreMessages.dialog_value_view_label_dictionary, (Object)refTable.getName()), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchWindow window = ReferenceValueEditor.this.valueController.getValueSite().getWorkbenchWindow();
                    UIUtils.runInUI((IRunnableContext)window, monitor -> {
                        DBNDatabaseNode tableNode = NavigatorUtils.getNodeByObject(monitor, (DBSObject)refTable, true);
                        if (tableNode != null) {
                            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)tableNode, DatabaseDataEditor.class.getName(), window);
                        }
                    });
                }
            });
            dictLabel.setLayoutData((Object)new GridData(32));
            Link hintLabel = UIUtils.createLink((Composite)labelGroup, (String)"(<a>Define Description</a>)", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(refTable);
                    if (editDictionaryPage.edit(parent.getShell())) {
                        ReferenceValueEditor.this.reloadSelectorValues(null);
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(896));
        }
        this.editorSelector = new Table(parent, 68356);
        this.editorSelector.setLinesVisible(true);
        this.editorSelector.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.editorSelector.setLayoutData((Object)gd);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)CoreMessages.dialog_value_view_column_value);
        valueColumn.setData((Object)Boolean.TRUE);
        TableColumn descColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)CoreMessages.dialog_value_view_column_description);
        descColumn.setData((Object)Boolean.FALSE);
        SortListener sortListener = new SortListener();
        valueColumn.addListener(13, (Listener)sortListener);
        descColumn.addListener(13, (Listener)sortListener);
        this.editorSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ReferenceValueEditor.this.editorSelector.getSelection();
                if (selection != null && selection.length > 0) {
                    Object value = selection[0].getData();
                    try {
                        ReferenceValueEditor.this.valueEditor.primeEditorValue(value);
                    }
                    catch (DBException e1) {
                        log.error((Object)e1);
                    }
                }
            }
        });
        Control control = this.valueEditor.getControl();
        ModifyListener modifyListener = e -> {
            Object curEditorValue;
            try {
                curEditorValue = this.valueEditor.extractEditorValue();
            }
            catch (DBException e1) {
                log.error((Object)e1);
                return;
            }
            String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curEditorValue, DBDDisplayFormat.UI);
            boolean valueFound = false;
            if (curTextValue != null) {
                TableItem[] tableItemArray = this.editorSelector.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (curTextValue.equalsIgnoreCase(item.getText(0)) || curTextValue.equalsIgnoreCase(item.getText(1))) {
                        this.editorSelector.select(this.editorSelector.indexOf(item));
                        this.editorSelector.showItem(item);
                        valueFound = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!valueFound) {
                this.reloadSelectorValues(curEditorValue);
            }
        };
        if (control instanceof Text) {
            ((Text)control).addModifyListener(modifyListener);
        } else if (control instanceof StyledText) {
            ((StyledText)control).addModifyListener(modifyListener);
        }
        if (this.refConstraint instanceof DBSEntityAssociation) {
            Text valueFilterText = new Text(parent, 2048);
            valueFilterText.setLayoutData((Object)new GridData(768));
            valueFilterText.addModifyListener(e -> {
                String filterPattern = valueFilterText.getText();
                this.reloadSelectorValues(filterPattern);
            });
            valueFilterText.addPaintListener(e -> {
                if (valueFilterText.isEnabled() && valueFilterText.getCharCount() == 0) {
                    e.gc.setForeground(parent.getDisplay().getSystemColor(18));
                    e.gc.drawText("Type part of dictionary value to search", 2, 0, true);
                    e.gc.setFont(null);
                }
            });
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.editorSelector, (boolean)true));
        Object curValue = this.valueController.getValue();
        this.reloadSelectorValues(curValue instanceof Number ? curValue : null);
        return true;
    }

    private void reloadSelectorValues(Object pattern) {
        if (CommonUtils.equalObjects((Object)this.lastPattern, (Object)pattern)) {
            return;
        }
        this.lastPattern = pattern;
        SelectorLoaderService loadingService = new SelectorLoaderService();
        if (pattern != null) {
            loadingService.setPattern(pattern);
        }
        LoadingJob.createService(loadingService, new SelectorLoaderVisualizer(loadingService)).schedule();
    }

    private void updateDictionarySelector(EnumValuesData valuesData) {
        if (this.editorSelector == null || this.editorSelector.isDisposed()) {
            return;
        }
        this.editorSelector.setRedraw(false);
        try {
            this.editorSelector.removeAll();
            for (DBDLabelValuePair entry : valuesData.keyValues) {
                TableItem discItem = new TableItem(this.editorSelector, 0);
                discItem.setText(0, valuesData.keyHandler.getValueDisplayString((DBSTypedObject)valuesData.keyColumn.getAttribute(), entry.getValue(), DBDDisplayFormat.UI));
                discItem.setText(1, entry.getLabel());
                discItem.setData(entry.getValue());
            }
            Control editorControl = this.valueEditor.getControl();
            if (editorControl != null && !editorControl.isDisposed()) {
                try {
                    Object curValue = this.valueEditor.extractEditorValue();
                    String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curValue, DBDDisplayFormat.UI);
                    TableItem curItem = null;
                    TableItem[] tableItemArray = this.editorSelector.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getText(0).equals(curTextValue)) {
                            curItem = item;
                            break;
                        }
                        ++n2;
                    }
                    if (curItem != null) {
                        this.editorSelector.setSelection(curItem);
                        this.editorSelector.showItem(curItem);
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            UIUtils.maxTableColumnsWidth((Table)this.editorSelector);
        }
        finally {
            this.editorSelector.setRedraw(true);
        }
    }

    private static class EnumValuesData {
        List<DBDLabelValuePair> keyValues;
        DBSEntityAttributeRef keyColumn;
        DBDValueHandler keyHandler;

        public EnumValuesData(Collection<DBDLabelValuePair> keyValues, DBSEntityAttributeRef keyColumn, DBDValueHandler keyHandler) {
            this.keyValues = new ArrayList<DBDLabelValuePair>(keyValues);
            this.keyColumn = keyColumn;
            this.keyHandler = keyHandler;
        }
    }

    class SelectorLoaderService
    extends AbstractLoadService<EnumValuesData> {
        private Object pattern;

        private SelectorLoaderService() {
            super(String.valueOf(CoreMessages.dialog_value_view_job_selector_name) + ReferenceValueEditor.this.valueController.getValueName() + " possible values");
        }

        void setPattern(@Nullable Object pattern) {
            this.pattern = pattern;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public EnumValuesData evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (ReferenceValueEditor.this.editorSelector.isDisposed()) {
                return null;
            }
            try {
                IAttributeController attributeController = (IAttributeController)ReferenceValueEditor.this.valueController;
                DBSEntityAttribute tableColumn = attributeController.getBinding().getEntityAttribute();
                if (tableColumn == null) {
                    return null;
                }
                DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)ReferenceValueEditor.this.refConstraint, (DBSEntityAttribute)tableColumn);
                if (fkColumn == null) {
                    return null;
                }
                if (!(ReferenceValueEditor.this.refConstraint instanceof DBSEntityAssociation)) return null;
                DBSEntityAssociation association = (DBSEntityAssociation)ReferenceValueEditor.this.refConstraint;
                DBSEntityAttribute refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                if (refColumn == null) {
                    return null;
                }
                ArrayList<DBDAttributeValue> precedingKeys = null;
                List allColumns = CommonUtils.safeList((List)ReferenceValueEditor.this.refConstraint.getAttributeReferences(monitor));
                if (allColumns.size() > 1 && allColumns.get(0) != fkColumn) {
                    DBSEntityAttributeRef precColumn;
                    List<DBDAttributeBinding> rowAttributes = attributeController.getRowController().getRowAttributes();
                    precedingKeys = new ArrayList<DBDAttributeValue>();
                    Iterator iterator = allColumns.iterator();
                    while (iterator.hasNext() && (precColumn = (DBSEntityAttributeRef)iterator.next()) != fkColumn) {
                        DBDAttributeBinding rowAttr;
                        DBSEntityAttribute precAttribute = precColumn.getAttribute();
                        if (precAttribute == null || (rowAttr = DBUtils.findBinding(rowAttributes, (DBSAttributeBase)precAttribute)) == null) continue;
                        Object precValue = attributeController.getRowController().getAttributeValue(rowAttr);
                        precedingKeys.add(new DBDAttributeValue((DBSAttributeBase)precAttribute, precValue));
                    }
                }
                DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
                DBSEntityConstraint refConstraint = association.getReferencedConstraint();
                DBSConstraintEnumerable enumConstraint = (DBSConstraintEnumerable)refConstraint;
                if (fkAttribute == null) return null;
                if (enumConstraint == null) return null;
                Throwable throwable = null;
                Object var13_15 = null;
                try {
                    DBCSession session = ReferenceValueEditor.this.valueController.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, NLS.bind((String)CoreMessages.dialog_value_view_context_name, (Object)fkAttribute.getName()));
                    try {
                        List enumValues = enumConstraint.getKeyEnumeration(session, refColumn, this.pattern, precedingKeys, ReferenceValueEditor.this.sortByValue, ReferenceValueEditor.this.sortAsc, 200);
                        if (monitor.isCanceled()) {
                            return null;
                        }
                        DBDValueHandler colHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)fkAttribute);
                        return new EnumValuesData(enumValues, fkColumn, colHandler);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (session == null) return null;
                        session.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
            return null;
        }

        public Object getFamily() {
            return ReferenceValueEditor.this.valueController.getExecutionContext();
        }
    }

    private class SelectorLoaderVisualizer
    extends ProgressLoaderVisualizer<EnumValuesData> {
        public SelectorLoaderVisualizer(SelectorLoaderService loadingService) {
            super((ILoadService)loadingService, (Composite)ReferenceValueEditor.this.editorSelector);
        }

        public void visualizeLoading() {
            super.visualizeLoading();
        }

        public void completeLoading(EnumValuesData result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
            if (result != null) {
                ReferenceValueEditor.this.updateDictionarySelector(result);
            }
        }
    }

    private class SortListener
    implements Listener {
        private TableColumn prevColumn = null;
        private int sortDirection = 1024;

        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            if (this.prevColumn == column) {
                this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
            }
            this.prevColumn = column;
            ReferenceValueEditor.this.sortByValue = (Boolean)column.getData();
            ReferenceValueEditor.this.sortAsc = this.sortDirection == 1024;
            ReferenceValueEditor.this.editorSelector.setSortColumn(column);
            ReferenceValueEditor.this.editorSelector.setSortDirection(this.sortDirection);
            ReferenceValueEditor.this.reloadSelectorValues(ReferenceValueEditor.this.lastPattern);
        }
    }
}

