/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingConfigDialog;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.utils.CommonUtils;

public class GroupingPanel
implements IResultSetPanel {
    private static final String PANEL_ID = "results-grouping";
    private static final String SETTINGS_SECTION_GROUPING = "panel-results-grouping";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private GroupingResultsContainer resultsContainer;

    @Override
    public Control createContents(final IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.resultsContainer = new GroupingResultsContainer(parent, presentation);
        IResultSetController groupingViewer = this.resultsContainer.getResultSetController();
        ResultSetListenerAdapter ownerListener = new ResultSetListenerAdapter(){
            String prevQueryText = null;

            @Override
            public void handleResultSetLoad() {
                String queryText = presentation.getController().getDataContainer().getName();
                if (this.prevQueryText != null && !CommonUtils.equalObjects((Object)this.prevQueryText, (Object)queryText)) {
                    GroupingPanel.this.resultsContainer.clearGrouping();
                } else {
                    try {
                        GroupingPanel.this.resultsContainer.rebuildGrouping();
                    }
                    catch (DBException e) {
                        DBUserInterface.getInstance().showError("Grouping error", "Can't refresh grouping query", (Throwable)e);
                    }
                }
                this.prevQueryText = queryText;
            }
        };
        this.presentation.getController().addListener(ownerListener);
        groupingViewer.getControl().addDisposeListener(e -> this.presentation.getController().removeListener(ownerListener));
        ResultSetListenerAdapter groupingResultsListener = new ResultSetListenerAdapter(){

            @Override
            public void handleResultSetLoad() {
                GroupingPanel.this.updateControls();
            }

            @Override
            public void handleResultSetSelectionChange(SelectionChangedEvent event) {
                GroupingPanel.this.updateControls();
            }
        };
        groupingViewer.addListener(groupingResultsListener);
        return groupingViewer.getControl();
    }

    @Override
    public boolean isDirty() {
        return !this.resultsContainer.getGroupAttributes().isEmpty();
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        IDialogSettings functionsSection = this.panelSettings.getSection("groups");
    }

    private void saveSettings() {
        IDialogSettings functionsSection = UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"groups");
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void refresh(boolean force) {
    }

    @Override
    public void contributeActions(ToolBarManager manager) {
        this.fillToolBar((IContributionManager)manager);
    }

    private void fillToolBar(IContributionManager contributionManager) {
        contributionManager.add((IAction)new DefaultSortingAction());
        contributionManager.add((IAction)new DuplicatesOnlyAction());
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new EditColumnsAction(this.resultsContainer));
        contributionManager.add((IAction)new DeleteColumnAction(this.resultsContainer));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new ClearGroupingAction(this.resultsContainer));
        contributionManager.add((IAction)new PresentationSelectAction());
    }

    class ChangeSortingAction
    extends Action {
        private final Boolean descending;

        ChangeSortingAction(Boolean descending) {
            super(descending == null ? "Unsorted" : (descending != false ? "Decending" : "Ascending"), 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)(descending == null ? UIIcon.SORT_UNKNOWN : (descending != false ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE))));
            this.descending = descending;
        }

        public boolean isChecked() {
            DBPDataSource dataSource = GroupingPanel.this.resultsContainer.getDataContainer().getDataSource();
            if (dataSource == null) {
                return false;
            }
            String defSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
            if (CommonUtils.isEmpty((String)defSorting)) {
                return this.descending == null;
            }
            if (defSorting.equals("ASC")) {
                return Boolean.FALSE.equals(this.descending);
            }
            return Boolean.TRUE.equals(this.descending);
        }

        public void run() {
            String newValue = this.descending == null ? "" : (this.descending != false ? "DESC" : "ASC");
            DBPDataSource dataSource = GroupingPanel.this.resultsContainer.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.defaultSorting", newValue);
            dataSource.getContainer().getRegistry().flushConfig();
            try {
                GroupingPanel.this.resultsContainer.rebuildGrouping();
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Grouping error", "Can't change duplicates presentation", (Throwable)e);
            }
        }
    }

    static class ClearGroupingAction
    extends GroupingAction {
        ClearGroupingAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_clear, UIUtils.getShardImageDescriptor((String)"IMG_ETOOL_CLEAR"));
        }

        public boolean isEnabled() {
            return !this.resultsContainer.getGroupAttributes().isEmpty();
        }

        public void run() {
            this.resultsContainer.clearGrouping();
            this.resultsContainer.getOwnerPresentation().getController().updatePanelActions();
        }
    }

    class DefaultSortingAction
    extends Action
    implements IMenuCreator {
        DefaultSortingAction() {
            super(CoreMessages.controls_resultset_grouping_default_sorting, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DROP_DOWN));
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new ChangeSortingAction(null));
            menuManager.add((IAction)new ChangeSortingAction(Boolean.FALSE));
            menuManager.add((IAction)new ChangeSortingAction(Boolean.TRUE));
            return menuManager.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    static class DeleteColumnAction
    extends GroupingAction {
        DeleteColumnAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_remove_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ACTION_OBJECT_DELETE));
        }

        public boolean isEnabled() {
            return !this.resultsContainer.getResultSetController().getSelection().isEmpty();
        }

        public void run() {
            List<String> attributes;
            DBDAttributeBinding currentAttribute = this.resultsContainer.getResultSetController().getActivePresentation().getCurrentAttribute();
            if (currentAttribute != null && (this.resultsContainer.removeGroupingAttribute(attributes = Collections.singletonList(currentAttribute.getFullyQualifiedName(DBPEvaluationContext.UI))) || this.resultsContainer.removeGroupingFunction(attributes))) {
                try {
                    this.resultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Grouping error", "Can't change grouping query", (Throwable)e);
                }
            }
        }
    }

    class DuplicatesOnlyAction
    extends Action {
        DuplicatesOnlyAction() {
            super(CoreMessages.controls_resultset_grouping_show_duplicates_only, 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.GROUP_BY_ATTR));
        }

        public boolean isChecked() {
            DBPDataSource dataSource = GroupingPanel.this.resultsContainer.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        }

        public void run() {
            boolean newValue = !this.isChecked();
            DBPDataSource dataSource = GroupingPanel.this.resultsContainer.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.showDuplicatesOnly", newValue);
            try {
                GroupingPanel.this.resultsContainer.rebuildGrouping();
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Grouping error", "Can't change duplicates presentation", (Throwable)e);
            }
        }
    }

    static class EditColumnsAction
    extends GroupingAction {
        EditColumnsAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_edit, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_ADD));
        }

        public void run() {
            GroupingConfigDialog dialog = new GroupingConfigDialog(this.resultsContainer.getResultSetController().getControl().getShell(), this.resultsContainer);
            if (dialog.open() == 0) {
                try {
                    this.resultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Grouping error", "Can't change grouping settings", (Throwable)e);
                }
            }
        }
    }

    static abstract class GroupingAction
    extends Action {
        final GroupingResultsContainer resultsContainer;

        GroupingAction(GroupingResultsContainer resultsContainer, String text, ImageDescriptor image) {
            super(text, image);
            this.resultsContainer = resultsContainer;
        }
    }

    private class PresentationSelectAction
    extends Action
    implements IMenuCreator {
        public PresentationSelectAction() {
            super("View", 4);
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            MenuManager menuManager = new MenuManager();
            List<ResultSetPresentationDescriptor> presentations = ((ResultSetViewer)GroupingPanel.this.resultsContainer.getResultSetController()).getAvailablePresentations();
            if (!CommonUtils.isEmpty(presentations)) {
                for (ResultSetPresentationDescriptor pd : presentations) {
                    menuManager.add((IAction)new PresentationToggleAction(pd));
                }
            }
            return menuManager.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class PresentationToggleAction
    extends Action {
        private final ResultSetPresentationDescriptor presentationDescriptor;

        public PresentationToggleAction(ResultSetPresentationDescriptor presentationDescriptor) {
            super(presentationDescriptor.getLabel(), 8);
            this.presentationDescriptor = presentationDescriptor;
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)presentationDescriptor.getIcon()));
            this.setToolTipText(presentationDescriptor.getDescription());
        }

        public boolean isChecked() {
            return this.presentationDescriptor.matches(GroupingPanel.this.resultsContainer.getResultSetController().getActivePresentation().getClass());
        }

        public void run() {
            ((ResultSetViewer)GroupingPanel.this.resultsContainer.getResultSetController()).switchPresentation(this.presentationDescriptor);
        }
    }
}

