/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerTogglePanel
extends AbstractHandler
implements IElementUpdater {
    public static final String CMD_TOGGLE_PANEL = "org.jkiss.dbeaver.core.resultset.grid.togglePanel";
    private static final String PARAM_PANEL_ID = "panelId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.grid.togglePanel": {
                ResultSetHandlerTogglePanel.toggleResultsPanel(resultSet, HandlerUtil.getActiveShell((ExecutionEvent)event), event.getParameter(PARAM_PANEL_ID));
            }
        }
        return null;
    }

    private static void toggleResultsPanel(IResultSetController resultSet, Shell shell, String panelId) {
        boolean isVisible = false;
        IResultSetPanel visiblePanel = resultSet.getVisiblePanel();
        if (visiblePanel != null) {
            String activePanelId = ((ResultSetViewer)resultSet).getActivePanelId();
            isVisible = CommonUtils.equalObjects((Object)activePanelId, (Object)panelId);
        }
        if (isVisible) {
            ((ResultSetViewer)resultSet).closeActivePanel();
        } else {
            resultSet.activatePanel(panelId, true, true);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

