/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;

public class ObjectPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.object";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE = "canCreate";
    public static final String PROP_CAN_PASTE = "canPaste";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_CAN_RENAME = "canRename";
    public static final String PROP_CAN_MOVE_UP = "canMoveUp";
    public static final String PROP_CAN_MOVE_DOWN = "canMoveDown";
    public static final String PROP_CAN_FILTER = "canFilter";
    public static final String PROP_CAN_FILTER_OBJECT = "canFilterObject";
    public static final String PROP_HAS_FILTER = "hasFilter";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof DBNNode)) {
            return false;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        DBNNode node = (DBNNode)receiver;
        switch (property) {
            case "canOpen": {
                return node.isPersisted();
            }
            case "canCreate": 
            case "canPaste": {
                if (node instanceof DBNResource) {
                    return property.equals(PROP_CAN_PASTE);
                }
                if (node instanceof DBNDataSource) {
                    return true;
                }
                if (!(node instanceof DBNContainer) && node.getParentNode() instanceof DBNContainer) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNContainer)) {
                    return false;
                }
                Class objectType = ((DBNContainer)node).getChildrenClass();
                DBNContainer container = (DBNContainer)node;
                if (node instanceof DBSWrapper && this.isReadOnly(((DBSWrapper)node).getObject())) {
                    return false;
                }
                if (objectType == null) {
                    return false;
                }
                DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(objectType, DBEObjectMaker.class);
                if (objectMaker == null) {
                    return false;
                }
                return objectMaker.canCreateObject(container.getValueObject());
            }
            case "canDelete": {
                if (node instanceof DBNDataSource || node instanceof DBNLocalFolder) {
                    return true;
                }
                if (node instanceof DBSWrapper) {
                    DBSObject object = ((DBSWrapper)node).getObject();
                    if (object == null || this.isReadOnly(object) || !(node.getParentNode() instanceof DBNContainer)) {
                        return false;
                    }
                    DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectMaker.class);
                    return objectMaker != null && objectMaker.canDeleteObject(object);
                }
                if (!(node instanceof DBNResource) || (((DBNResource)node).getFeatures() & 2) == 0) break;
                return true;
            }
            case "canRename": {
                if (node.supportsRename()) {
                    return true;
                }
                if (!(node instanceof DBNDatabaseNode)) break;
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                return object != null && !this.isReadOnly(object) && object.isPersisted() && node.getParentNode() instanceof DBNContainer && ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectRenamer.class) != null;
            }
            case "canMoveDown": 
            case "canMoveUp": {
                DBEObjectReorderer objectReorderer;
                DBSObject object;
                if (!(node instanceof DBNDatabaseNode) || !((object = ((DBNDatabaseNode)node).getObject()) instanceof DBPOrderedObject) || (objectReorderer = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectReorderer.class)) == null) break;
                int position = ((DBPOrderedObject)object).getOrdinalPosition();
                if (property.equals(PROP_CAN_MOVE_UP)) {
                    return position > objectReorderer.getMinimumOrdinalPosition(object);
                }
                return position < objectReorderer.getMaximumOrdinalPosition(object);
            }
            case "canFilter": {
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node).getItemsMeta() == null) break;
                return true;
            }
            case "canFilterObject": {
                if (!(node.getParentNode() instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node.getParentNode()).getItemsMeta() == null) break;
                return true;
            }
            case "hasFilter": {
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node).getItemsMeta() == null) break;
                DBSObjectFilter filter = ((DBNDatabaseFolder)node).getNodeFilter(((DBNDatabaseFolder)node).getItemsMeta(), true);
                if ("defined".equals(expectedValue)) {
                    return filter != null && !filter.isEmpty();
                }
                return filter != null && !filter.isNotApplicable();
            }
        }
        return false;
    }

    private boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || dataSource.getContainer().isConnectionReadOnly();
    }

    private static <T extends DBEObjectManager> T getObjectManager(Class<?> objectType, Class<T> managerType) {
        return (T)((DBEObjectManager)EntityEditorsRegistry.getInstance().getObjectManager(objectType, managerType));
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.object." + propName));
    }
}

