/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.tools.scripts.ScriptsExportData;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class ScriptsExportWizardPage
extends WizardPage {
    private static final Log log = Log.getLog(ScriptsExportWizardPage.class);
    static final String PREF_SCRIPTS_EXPORT_OUT_DIR = "export.scripts.out.dir";
    private Button overwriteCheck;
    private Text directoryText;
    private DatabaseNavigatorTree scriptsNavigator;
    private final List<DBNResource> selectedResources = new ArrayList<DBNResource>();

    protected ScriptsExportWizardPage(String pageName) {
        super(pageName);
        this.setTitle(CoreMessages.dialog_project_export_wizard_page_title);
    }

    public boolean isPageComplete() {
        if (this.directoryText == null || this.directoryText.isDisposed() || this.scriptsNavigator == null || this.scriptsNavigator.isDisposed()) {
            return false;
        }
        if (CommonUtils.isEmpty((String)this.directoryText.getText())) {
            this.setMessage(CoreMessages.dialog_project_export_wizard_page_message_no_output_dir, 3);
            return false;
        }
        this.selectedResources.clear();
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.scriptsNavigator.getViewer();
        Object[] objectArray = viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof DBNResource) {
                this.selectedResources.add((DBNResource)obj);
            }
            ++n2;
        }
        if (this.selectedResources.isEmpty()) {
            this.setMessage(CoreMessages.dialog_project_export_wizard_page_message_check_script, 3);
            return false;
        }
        this.setMessage(CoreMessages.dialog_project_export_wizard_page_message_configure_settings, 0);
        return true;
    }

    public void createControl(Composite parent) {
        String outDir = DBeaverCore.getGlobalPreferenceStore().getString(PREF_SCRIPTS_EXPORT_OUT_DIR);
        if (CommonUtils.isEmpty((String)outDir)) {
            outDir = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        placeholder.setLayout((Layout)new GridLayout(1, false));
        this.scriptsNavigator = new DatabaseNavigatorTree(placeholder, (DBNNode)DBeaverCore.getInstance().getNavigatorModel().getRoot(), 2080);
        GridData gd = new GridData(1808);
        this.scriptsNavigator.setLayoutData(gd);
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.scriptsNavigator.getViewer();
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ScriptsExportWizardPage.this.updateState();
            }
        });
        this.scriptsNavigator.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IContainer;
            }
        });
        Composite generalSettings = UIUtils.createPlaceholder((Composite)placeholder, (int)3);
        generalSettings.setLayoutData((Object)new GridData(768));
        this.overwriteCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)CoreMessages.dialog_project_export_wizard_page_checkbox_overwrite_files, (boolean)false);
        gd = new GridData(1);
        gd.horizontalSpan = 3;
        this.overwriteCheck.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)generalSettings, (String)CoreMessages.dialog_project_export_wizard_page_label_directory);
        this.directoryText = new Text(generalSettings, 2048);
        this.directoryText.setText(outDir);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptsExportWizardPage.this.updateState();
            }
        });
        Button openFolder = new Button(generalSettings, 8);
        openFolder.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        openFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ScriptsExportWizardPage.this.getShell(), 0);
                dialog.setMessage(CoreMessages.dialog_project_export_wizard_page_dialog_choose_export_dir_message);
                dialog.setText(CoreMessages.dialog_project_export_wizard_page_dialog_choose_export_dir_text);
                String directory = ScriptsExportWizardPage.this.directoryText.getText();
                if (!CommonUtils.isEmpty((String)directory)) {
                    dialog.setFilterPath(directory);
                }
                if ((directory = dialog.open()) != null) {
                    ScriptsExportWizardPage.this.directoryText.setText(directory);
                }
            }
        });
        this.setControl((Control)placeholder);
        this.updateState();
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }

    public ScriptsExportData getExportData() {
        IResource resource;
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (DBNResource resourceNode : this.selectedResources) {
            resource = resourceNode.getResource();
            if (!(resource instanceof IFolder)) continue;
            this.addResourceToSet(result, resource);
        }
        for (DBNResource resourceNode : this.selectedResources) {
            resource = resourceNode.getResource();
            this.addResourceToSet(result, resource);
        }
        String outputDir = this.directoryText.getText();
        DBeaverCore.getGlobalPreferenceStore().setValue(PREF_SCRIPTS_EXPORT_OUT_DIR, outputDir);
        return new ScriptsExportData(result, this.overwriteCheck.getSelection(), new File(outputDir));
    }

    private void addResourceToSet(Set<IResource> result, IResource resource) {
        boolean skip = false;
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (result.contains(parent)) {
                skip = true;
                break;
            }
            parent = parent.getParent();
        }
        if (!skip) {
            result.add(resource);
        }
    }
}

