/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.model;

import com.dbeaver.ee.qmdb.model.QMDBModel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMEventBrowser;
import org.jkiss.dbeaver.model.qm.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.LongKeyMap;

public class QMDBEventBrowser
implements QMEventBrowser {
    private static final Log log = Log.getLog(QMDBEventBrowser.class);
    private final QMDBModel model;
    private final Map<String, DataSourceInfo> dataSourceCache = new HashMap<String, DataSourceInfo>();
    private final LongKeyMap<QMMSessionInfo> sessionCache = new LongKeyMap();

    public QMDBEventBrowser(QMDBModel qMDBModel) {
        this.model = qMDBModel;
    }

    public QMEventCursor getQueryHistoryCursor(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull QMEventCriteria qMEventCriteria) throws DBException {
        try {
            return new QMDBEventCursor(qMEventCriteria);
        }
        catch (SQLException sQLException) {
            throw new DBException("Error getting filter history", (Throwable)sQLException);
        }
    }

    private QMMSessionInfo getSessionInfo(long l, String string, String string2, long l2) throws DBException {
        QMMSessionInfo qMMSessionInfo = (QMMSessionInfo)this.sessionCache.get(l);
        if (qMMSessionInfo == null) {
            DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
            DBPConnectionConfiguration dBPConnectionConfiguration = new DBPConnectionConfiguration();
            dBPConnectionConfiguration.setUrl(dataSourceInfo.url);
            qMMSessionInfo = new QMMSessionInfo(l2, l2, string, dataSourceInfo.name, dataSourceInfo.driverID, dBPConnectionConfiguration, string2, false);
            this.sessionCache.put(l, (Object)qMMSessionInfo);
        }
        return qMMSessionInfo;
    }

    private synchronized DataSourceInfo getDataSourceInfo(String string) throws DBException {
        DataSourceInfo dataSourceInfo = this.dataSourceCache.get(string);
        if (dataSourceInfo == null) {
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.containerID = string;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PreparedStatement preparedStatement = this.model.getConnection().prepareStatement("SELECT * FROM QM_DATASOURCE WHERE DATASOURCE_ID=?");){
                    preparedStatement.setString(1, string);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (resultSet.next()) {
                            dataSourceInfo.name = resultSet.getString("NAME");
                            dataSourceInfo.url = resultSet.getString("URL");
                            dataSourceInfo.driverID = resultSet.getString("DRIVER");
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                throw new DBException("Error reading datasource info", (Throwable)sQLException);
            }
            this.dataSourceCache.put(string, dataSourceInfo);
        }
        return dataSourceInfo;
    }

    private static class DataSourceInfo {
        String containerID;
        String driverID;
        String name;
        String url;

        private DataSourceInfo() {
        }
    }

    private class QMDBEventCursor
    implements QMEventCursor {
        public static final int EVENTS_MAX_SIZE = 2000;
        private final Statement eventStat;
        private final ResultSet eventResults;
        private QMMetaEvent nextEvent;
        private Boolean hasNext;

        public QMDBEventCursor(QMEventCriteria qMEventCriteria) throws SQLException {
            log.debug((Object)"Reading event history from QMDB");
            this.eventStat = QMDBEventBrowser.this.model.getConnection().createStatement(1003, 1007);
            try {
                Object object;
                this.eventStat.setFetchSize(200);
                this.eventStat.setMaxRows(2000);
                String string = qMEventCriteria.getSearchString();
                if (!CommonUtils.isEmpty((String)string)) {
                    string = string.replace("'", "''").toLowerCase();
                    log.debug((Object)("Search for events '" + string + "'"));
                }
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                if (qMEventCriteria.hasObjectTypes() || qMEventCriteria.hasQueryTypes()) {
                    int n;
                    if (qMEventCriteria.hasObjectTypes()) {
                        object = new ArrayList();
                        if (qMEventCriteria.hasObjectType(QMObjectType.session)) {
                            object.add(1);
                        }
                        if (qMEventCriteria.hasObjectType(QMObjectType.txn)) {
                            object.add(2);
                            object.add(3);
                        }
                        if (qMEventCriteria.hasObjectType(QMObjectType.query)) {
                            object.add(4);
                            object.add(5);
                        }
                        stringBuilder.append("EVENT_TYPE IN (");
                        n = 0;
                        while (n < object.size()) {
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(object.get(n));
                            ++n;
                        }
                        stringBuilder.append(")");
                    }
                    if (qMEventCriteria.hasQueryTypes()) {
                        stringBuilder2.append(" AND STATEMENT_PURPOSE IN (");
                        object = qMEventCriteria.getQueryTypes();
                        n = 0;
                        while (n < ((DBCExecutionPurpose[])object).length) {
                            DBCExecutionPurpose dBCExecutionPurpose = object[n];
                            if (n > 0) {
                                stringBuilder2.append(",");
                            }
                            stringBuilder2.append(dBCExecutionPurpose.getId());
                            ++n;
                        }
                        stringBuilder2.append(")");
                    }
                }
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("(EVENT_ACTION = 1 OR EVENT_TYPE = 1)");
                }
                object = CommonUtils.isEmpty((String)string) ? "SELECT \ne.CONNECTION_ID,e.EVENT_ACTION,e.EVENT_TYPE,e.EVENT_TIME,\nc.DATASOURCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT \nFROM QM_EVENT e\nLEFT JOIN QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID \nLEFT OUTER JOIN QM_STATEMENT s ON s.STATEMENT_ID = e.EVENT_ID\nLEFT OUTER JOIN QM_QUERY q ON q.QUERY_ID = s.QUERY_ID\nWHERE " + stringBuilder + stringBuilder2 + "\n" + "ORDER BY e.EVENT_ID DESC" : "SELECT * FROM (\nSELECT \ne.CONNECTION_ID,e.EVENT_ACTION,EVENT_TYPE,e.EVENT_TIME,\nc.DATASOURCE_ID,c.CONTEXT_NAME,\ns.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,\nq.QUERY_TEXT \nFROM QM_QUERY q\nJOIN QM_STATEMENT s ON s.QUERY_ID = q.QUERY_ID\nJOIN QM_EVENT e ON e.EVENT_ID = s.STATEMENT_ID \nJOIN QM_CONNECTION c ON c.CONNECTION_ID = e.CONNECTION_ID\nWHERE lower(q.QUERY_TEXT) LIKE '%" + string + "%'\n" + "ORDER BY e.EVENT_ID DESC\n" + ") WHERE " + stringBuilder + stringBuilder2;
                this.eventResults = this.eventStat.executeQuery((String)object);
            }
            catch (SQLException sQLException) {
                this.eventStat.close();
                throw sQLException;
            }
        }

        public long getTotalSize() {
            return -1L;
        }

        public void scroll(int n, DBRProgressMonitor dBRProgressMonitor) throws DBException {
            try {
                this.eventResults.absolute(n + 1);
            }
            catch (SQLException sQLException) {
                throw new DBException("Error scrolling cursor", (Throwable)sQLException);
            }
        }

        public boolean hasNextEvent(DBRProgressMonitor dBRProgressMonitor) throws DBException {
            this.fetchNext(dBRProgressMonitor);
            return this.hasNext != null && this.hasNext != false;
        }

        public QMMetaEvent nextEvent(DBRProgressMonitor dBRProgressMonitor) throws DBException {
            try {
                if (this.nextEvent != null) {
                    QMMetaEvent qMMetaEvent = this.nextEvent;
                    return qMMetaEvent;
                }
                this.fetchNext(dBRProgressMonitor);
                QMMetaEvent qMMetaEvent = this.nextEvent;
                return qMMetaEvent;
            }
            finally {
                this.hasNext = null;
                this.nextEvent = null;
            }
        }

        private void fetchNext(DBRProgressMonitor dBRProgressMonitor) throws DBException {
            QMMSessionInfo qMMSessionInfo;
            if (this.nextEvent != null || this.hasNext != null) {
                return;
            }
            try {
                this.hasNext = this.eventResults.next();
            }
            catch (SQLException sQLException) {
                throw new DBException("Error fetching cursor", (Throwable)sQLException);
            }
            if (!this.hasNext.booleanValue()) {
                return;
            }
            long l = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)1);
            int n = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)2);
            int n2 = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)3);
            Timestamp timestamp = JDBCUtils.safeGetTimestamp((ResultSet)this.eventResults, (int)4);
            String string = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)5);
            String string2 = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)6);
            int n3 = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)7);
            long l2 = JDBCUtils.safeGetLong((ResultSet)this.eventResults, (int)8);
            int n4 = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)9);
            String string3 = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)10);
            int n5 = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)11);
            int n6 = JDBCUtils.safeGetInt((ResultSet)this.eventResults, (int)12);
            String string4 = JDBCUtils.safeGetString((ResultSet)this.eventResults, (int)13);
            long l3 = timestamp == null ? 0L : ((Date)timestamp).getTime();
            QMMSessionInfo qMMSessionInfo2 = QMDBEventBrowser.this.getSessionInfo(l, string, string2, l3);
            if (n2 == 1) {
                qMMSessionInfo = qMMSessionInfo2;
            } else {
                QMMStatementInfo qMMStatementInfo = new QMMStatementInfo(l3, l3 + (long)n5, qMMSessionInfo2, DBCExecutionPurpose.getById((int)n3));
                qMMSessionInfo = new QMMStatementExecuteInfo(l3, l3 + (long)n5, qMMStatementInfo, string4, l2, n4, string3, l3, l3 + (long)n6, false);
            }
            this.nextEvent = new QMMetaEvent((QMMObject)qMMSessionInfo, QMMetaEvent.Action.getById((int)n));
        }

        public void close() {
            if (this.eventResults != null) {
                IOUtils.close((AutoCloseable)this.eventResults);
            }
            if (this.eventStat != null) {
                IOUtils.close((AutoCloseable)this.eventStat);
            }
        }
    }
}

