/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import oracle.xml.xti.QNameKey;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class XTIEncoder
implements ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
XTIConstants {
    XMLError err = null;
    private XTIStream xtiStream;
    private boolean cdata = false;
    private byte[] xtinRootPageHeader = null;
    private byte[] xticRootPageHeader = null;
    private Stack<Integer> parent = new Stack();
    private int curParentAddress = 0;
    private HashMap<Integer, Integer> parentFirstChild = new HashMap(10);
    private int currentXTINpageNumber = 1;
    private int currentXTINArraySlot = -1;
    private int previousXTINAddress = 0;
    private int currentXTINAddress = 0;
    private int freeBytesQname = 4091;
    private int freeBytesText = 4091;
    private int totalXTICPages = 0;
    private int lastTextPage = 1;
    private int lastQnamePage = 1;
    private char[] charBuffer = new char[4096];
    private int charLength = 0;
    private int xticmode = -1;
    private String xmlencoding = null;
    private String xmlversion = null;
    private String standalone = null;
    private byte xtinSchemaHeaderFlag = 0;
    private Locator locator = null;
    private byte compression = 0;
    private boolean updateInit = false;
    private QNameKey qkey = new QNameKey();

    XTIEncoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
        this.xtiStream.setXMLError(xMLError);
    }

    private XMLError getXMLError() {
        if (this.err == null) {
            this.err = new XMLError();
            this.xtiStream.setXMLError(this.err);
        }
        return this.err;
    }

    private int getUTF8BytesSize(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
            this.xticmode = 0;
        }
        return byArray.length;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        System.arraycopy(cArray, n, this.charBuffer, this.charLength, n2);
        this.charLength += n2;
    }

    private void printAddressRelations() {
        Set<Integer> set = this.parentFirstChild.keySet();
        for (int n : set) {
            int n2 = this.parentFirstChild.get(n);
            System.out.println(n + "'s first is: " + n2);
        }
    }

    void unsetIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by & 0xEF);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    private void updateParentFirstChild(int n) {
        if (n == 0) {
            return;
        }
        Integer n2 = this.parentFirstChild.get(this.curParentAddress);
        if (n2 == null) {
            this.parentFirstChild.put(this.curParentAddress, n);
        }
    }

    private void flushCharacters() throws SAXException {
        try {
            int n;
            byte[] byArray = new byte[32];
            byArray[0] = this.cdata ? 4 : 3;
            this.xticmode = 2;
            String string = new String(this.charBuffer, 0, this.charLength);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[16 + n] = byArray2[n];
            }
            if (this.parent.size() != 0) {
                n = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = this.currentXTINAddress;
            this.charLength = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int n;
        if (this.xtiStream.isInterleaving()) {
            this.compression = (byte)(this.compression | 9);
        }
        this.xtinRootPageHeader[0] = (byte)(0x10 | this.compression);
        this.xtinRootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
        byte[] byArray = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (n = 0; n < byArray.length; ++n) {
            this.xtinRootPageHeader[4 + n] = byArray[n];
        }
        if (this.xtinSchemaHeaderFlag != 0) {
            this.xtinRootPageHeader[17] = this.xtinSchemaHeaderFlag;
            if (this.xmlencoding != null) {
                n = this.xmlencoding.length();
                int[] nArray = this.getXTICTextAddress(++n);
                byArray = XTIUtil.intToByteArray(nArray[0]);
                for (int i = 0; i < 4; ++i) {
                    this.xtinRootPageHeader[13 + i] = byArray[i];
                }
                this.xtiStream.writeTextToAddress(nArray, this.xmlencoding);
            }
        }
        this.xtiStream.setXTINPageNumber(0, this.xtinRootPageHeader);
        this.xticRootPageHeader = this.xtiStream.getXTICPageNumber(0);
        this.xticRootPageHeader[0] = 1;
        byArray = XTIUtil.shortToByteArray(this.freeBytesQname);
        this.xticRootPageHeader[2] = byArray[0];
        this.xticRootPageHeader[3] = byArray[1];
        byArray = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[4 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.freeBytesText);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[8 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastTextPage);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[12 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n = 0; n < byArray.length; ++n) {
            this.xticRootPageHeader[16 + n] = byArray[n];
        }
        this.xtiStream.setXTICPageNumber(0, this.xticRootPageHeader);
        try {
            this.xtiStream.flushToStream();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.previousXTINAddress = this.parent.pop();
        this.curParentAddress = this.parent.peek();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            int n;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            this.xticmode = 2;
            int[] nArray = new int[]{this.getXTICTextAddress(this.getUTF8BytesSize(string2))[0], this.getXTICTextAddress(this.getUTF8BytesSize(string))[0]};
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            if (this.previousXTINAddress != 0) {
                byArray2 = XTIUtil.intToByteArray(this.previousXTINAddress);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[16 + n] = byArray2[n];
                }
            }
            if (this.parent.size() != 0) {
                n = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlversion = ((Locator2)this.locator).getXMLVersion();
                if (this.xmlversion != null && this.xmlversion.length() > 0) {
                    this.compression = (byte)(this.compression | 4);
                    this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 1);
                }
                if (this.locator instanceof XMLLocator) {
                    if (this.xmlencoding == null) {
                        this.xmlencoding = ((XMLLocator)this.locator).getDeclEncoding();
                        if (this.xmlencoding != null && this.xmlencoding.length() > 0) {
                            this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 2);
                        }
                    }
                    if (this.standalone == null) {
                        this.standalone = ((XMLLocator)this.locator).getStandalone();
                        if (this.standalone != null && this.standalone.length() > 0) {
                            if (this.standalone.equals("yes")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 8);
                            } else if (this.standalone.equals("no")) {
                                this.xtinSchemaHeaderFlag = (byte)(this.xtinSchemaHeaderFlag | 4);
                            }
                        }
                    }
                }
            }
            this.xtinRootPageHeader = this.xtiStream.getXTINPageNumber(0);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            this.parent.push(this.currentXTINAddress);
            this.curParentAddress = this.parent.peek();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            int n2;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string3), string2, string3);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[16 + n2] = byArray2[n2];
            }
            if (this.parent.size() != 0) {
                n2 = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n2);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[20 + n] = byArray2[n];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            n2 = this.updateAttributeNode(attributes);
            byArray2 = XTIUtil.intToByteArray(n2);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[28 + n] = byArray2[n];
            }
            this.parent.push(this.currentXTINAddress);
            this.curParentAddress = this.parent.peek();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private int updateAttributeNode(Attributes attributes) throws XTIException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                int n4;
                n3 = n2;
                n2 = this.getXTINAddress();
                if (i == 0) {
                    n = n2;
                }
                byArray = new byte[32];
                byArray[0] = 2;
                byte[] byArray2 = this.getQNameAddress(attributes.getURI(i), XMLUtil.getPrefix(attributes.getQName(i)), attributes.getLocalName(i), attributes.getQName(i));
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray[4 + j] = byArray2[j];
                }
                this.xticmode = 2;
                int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(attributes.getValue(i)));
                this.xtiStream.writeTextToAddress(nArray, attributes.getValue(i));
                byArray2 = XTIUtil.intToByteArray(nArray[0]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[16 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[12 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(this.currentXTINAddress);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[20 + n4] = byArray2[n4];
                }
                if (i != 0) {
                    this.updateNextAttributeForXTIN(n3, n2);
                }
                if (XMLUtil.getPrefix(attributes.getQName(i)).equals("xmlns")) {
                    byArray[29] = 2;
                } else if (XMLUtil.getPrefix(attributes.getQName(i)).length() == 0 && attributes.getLocalName(i).equals("xmlns")) {
                    byArray[29] = 4;
                }
                this.xtiStream.writeToXTINAddress(n2, byArray, false);
            }
            return n;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void updateNextAttributeForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateLastFirst4XTINLink(int n, int n2) {
        if (n == 0) {
            n = n2;
        }
        int n3 = n2 & 0xFF;
        int n4 = (n2 & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        int n5 = n3 * 32 + 24;
        byArray[n5] = (byte)(n >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n >>> 0 & 0xFF);
        int n6 = n & 0xFF;
        int n7 = (n & 0x7FFFFF00) >>> 8;
        int n8 = n6 * 32 + 16;
        if (n4 == n7) {
            byArray[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n4, byArray);
        } else {
            this.xtiStream.setXTINPageNumber(n4, byArray);
            byte[] byArray2 = this.xtiStream.getXTINPageNumber(n7);
            byArray2[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray2[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray2[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray2[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n7, byArray2);
        }
    }

    private void updatePreviousForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 16;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateNextForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
        if (n != n2 && n != 0) {
            this.unsetIsLastChildFlag(n);
        }
    }

    private void updateChildForXTIN(int n) {
        int n2 = this.parent.peek() & 0xFF;
        int n3 = (this.parent.peek() & 0x7FFFFF00) >>> 8;
        int n4 = n2 * 32 + 12;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n3);
        byArray[n4] = (byte)(n >>> 24 & 0xFF);
        byArray[n4 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n4 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n4 + 3] = (byte)(n >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n3, byArray);
    }

    private int getXTINAddress() {
        int n = 0;
        boolean bl = false;
        if (this.currentXTINpageNumber == 1 && this.currentXTINArraySlot == -1) {
            bl = true;
        }
        if (this.currentXTINArraySlot + 1 >= 256) {
            this.currentXTINArraySlot = 0;
            ++this.currentXTINpageNumber;
        } else {
            ++this.currentXTINArraySlot;
        }
        int n2 = n << 32 | this.currentXTINpageNumber << 8 | this.currentXTINArraySlot;
        if (bl) {
            this.updateXTINRootAddress(n2);
        }
        return n2;
    }

    private void updateXTINRootAddress(int n) {
        byte[] byArray = XTIUtil.intToByteArray(n);
        for (int i = 0; i < byArray.length; ++i) {
            this.xtinRootPageHeader[8 + i] = byArray[i];
        }
    }

    private int getXTICAddress(int n, int n2, int n3, byte by) {
        int n4 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n5 = 5;
        int n6 = 0;
        int n7 = 0;
        if (n2 == n4) {
            n3 = ++this.totalXTICPages;
        }
        if (n < n2) {
            n6 = n3;
            n5 += n4 - n2;
            n2 -= n;
        } else if (n <= n4) {
            n3 = ++this.totalXTICPages;
            n2 = n4 - n;
            n6 = n3;
        } else {
            int n8 = (int)Math.round((double)(n / n4) + 0.5);
            n6 = this.totalXTICPages + 1;
            this.totalXTICPages += n8;
            n3 = this.totalXTICPages;
            n2 = n4 - n % n4;
            this.xtiStream.setZeroAvailByteStartPageNum(n6);
            this.xtiStream.setZeroAvailByteEndPageNum(n3 - 1);
        }
        n7 = n6 << 12 | n5;
        switch (by) {
            case 2: {
                this.lastQnamePage = n3;
                this.freeBytesQname = n2;
                this.xtiStream.setFreeBytesQname(this.freeBytesQname);
                break;
            }
            case 1: {
                this.lastQnamePage = n3;
                this.freeBytesQname = n2;
                this.xtiStream.setFreeBytesQname(this.freeBytesQname);
                break;
            }
            case 3: {
                this.lastTextPage = n3;
                this.freeBytesText = n2;
                this.xtiStream.setFreeBytesText(this.freeBytesText);
            }
        }
        return n7;
    }

    private int[] getXTICTextAddress(int n) {
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesText, this.lastTextPage, (byte)3);
        return nArray;
    }

    private byte[] getQNameAddress(String string, String string2, String string3, String string4) throws XTIException {
        this.qkey.set(string, string4);
        byte[] byArray = this.xtiStream.qnameHash.get(this.qkey);
        if (byArray == null) {
            int[] nArray = this.getXTICQnameAddress(string.length(), string2.length(), string3.length());
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeQnameTOAddress(nArray, string, string2, string3);
            long l = nArray[0];
            l = l << 32 | (long)nArray[1];
            byArray = XTIUtil.longToByteArray(l);
            QxName qxName = QxNameHash.create(string, string3, string2, string4);
            this.xtiStream.qnameHash.put(new QNameKey(string, string4), byArray);
            this.xtiStream.qnameCache.put(l, qxName);
        }
        return byArray;
    }

    private int[] getXTICQnameAddress(int n, int n2, int n3) {
        int[] nArray = new int[2];
        this.xticmode = 1;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesQname, this.lastQnamePage, (byte)2);
        int n4 = n2 + n3 + 3;
        nArray[1] = this.getXTICAddress(n4, this.freeBytesQname, this.lastQnamePage, (byte)1);
        return nArray;
    }

    private int[] getXTICPIAddress(int n, int n2) {
        int[] nArray = new int[2];
        this.xticmode = 1;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesQname, this.lastQnamePage, (byte)1);
        nArray[1] = this.getXTICAddress(++n2, this.freeBytesQname, this.lastQnamePage, (byte)1);
        return nArray;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 8;
            this.xticmode = 2;
            String string = new String(cArray, n, n2);
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[8 + n3] = byArray2[n3];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[4 + n3] = byArray2[n3];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            if (this.previousXTINAddress != 0) {
                byArray2 = XTIUtil.intToByteArray(this.previousXTINAddress);
                for (n3 = 0; n3 < byArray2.length; ++n3) {
                    byArray[16 + n3] = byArray2[n3];
                }
            }
            if (this.parent.size() != 0) {
                n3 = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n3);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = false;
    }

    @Override
    public void endDTD() throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void endEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = true;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.err = this.getXMLError();
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    private void loadPage(int n, int n2) {
        if (n == 0) {
            this.xtiStream.readXTINPage(n2);
        } else if (n == 1) {
            this.xtiStream.readXTICPage(n2);
        }
    }
}

