/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import oracle.xml.parser.schema.JXSchema;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JXValidator
extends Validator {
    XSDValidator validator = new XSDValidator();
    LSResourceResolver resolver;
    XMLError error = new XMLError();

    JXValidator(Schema schema) throws XSDException, SAXException {
        this.validator.setError(this.error);
        XMLSchema xMLSchema = ((JXSchema)schema).schema;
        if (xMLSchema != null) {
            this.validator.setXMLSchema(xMLSchema);
        }
    }

    @Override
    public void reset() {
        this.validator.reset();
    }

    @Override
    public void validate(Source source) throws SAXException, IOException {
        this.validate(source, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        if (source instanceof DOMSource && (result == null || result instanceof DOMResult)) {
            try {
                XMLNode xMLNode = (XMLNode)((DOMSource)source).getNode();
                XMLNode xMLNode2 = null;
                if (!(xMLNode instanceof XMLElement)) return;
                if (result != null) {
                    xMLNode2 = ((XMLElement)xMLNode).validateContent(this.validator, true);
                    ((DOMResult)result).setNode(xMLNode2);
                } else {
                    ((XMLElement)xMLNode).validateContent(this.validator, false);
                }
                this.error.flushErrors();
                return;
            }
            catch (Exception exception) {
                throw new SAXException(exception.getMessage());
            }
        }
        if (!(source instanceof SAXSource) || result != null && !(result instanceof SAXResult)) throw new IllegalArgumentException();
        try {
            InputSource inputSource = ((SAXSource)source).getInputSource();
            XMLReader xMLReader = ((SAXSource)source).getXMLReader();
            xMLReader.setContentHandler(this.validator);
            if (result != null) {
                this.validator.addContentHandler(((SAXResult)result).getHandler());
            }
            xMLReader.parse(inputSource);
            return;
        }
        catch (Exception exception) {
            throw new SAXException(exception.getMessage());
        }
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.validator.setErrorHandler(errorHandler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.validator.getErrorHandler();
    }

    @Override
    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resolver = lSResourceResolver;
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(string);
    }
}

