/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.net.URL;
import oracle.xml.binxml.BinXMLDecodeReader;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLEncoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.XMLError;

public class BinXMLStreamImpl
extends BinaryStream
implements BinXMLStream {
    BinXMLEncoderImpl encoder;
    BinXMLProcessorImpl binXMLProcessor;
    String streamURI;
    XMLError err;

    @Override
    public BinXMLEncoder getEncoder() throws BinXMLException {
        if (this.encoder != null) {
            throw new BinXMLException("Encoder already out");
        }
        BinXMLEncoderImpl binXMLEncoderImpl = new BinXMLEncoderImpl(this);
        binXMLEncoderImpl.setXMLError(this.err);
        return binXMLEncoderImpl;
    }

    @Override
    public BinXMLDecoder getDecoder() throws BinXMLException {
        BinXMLDecoderImpl binXMLDecoderImpl = new BinXMLDecoderImpl(this);
        binXMLDecoderImpl.setXMLError(this.err);
        if (this.encoder != null) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                throw new BinXMLException(iOException);
            }
        }
        return binXMLDecoderImpl;
    }

    @Override
    public InfosetReader getInfosetReader() {
        try {
            return this.getDecoder().getReader();
        }
        catch (BinXMLException binXMLException) {
            throw new RuntimeException(binXMLException);
        }
    }

    public void setStreamURI(String string) {
        this.streamURI = string;
    }

    public String getStreamURI() {
        return this.streamURI;
    }

    BinXMLStreamImpl(BinXMLProcessor binXMLProcessor) {
        this.binXMLProcessor = (BinXMLProcessorImpl)binXMLProcessor;
        this.err = this.binXMLProcessor.getXMLError();
    }

    public BinXMLProcessor getBinXMLProcessor() {
        return this.binXMLProcessor;
    }

    void setURL(URL uRL) throws IOException {
    }

    long readBytes(BinXMLDecodeReader binXMLDecodeReader, byte[] byArray, long l) throws BinXMLException {
        return binXMLDecodeReader.readBytes(this, byArray, l);
    }

    long skipBytes(BinXMLDecodeReader binXMLDecodeReader, long l) throws BinXMLException {
        return binXMLDecodeReader.skipBytes(this, l);
    }

    static void writeNum2(int n, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)(n & 0xFF);
        byArray[n2] = (byte)((n >>= 8) & 0xFF);
    }

    static int readNum2(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 <<= 8;
        return n2 |= byArray[n] & 0xFF;
    }

    static void writeNum4(long l, byte[] byArray, int n) {
        n += 3;
        byArray[n--] = (byte)(l & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n] = (byte)((l >>= 8) & 0xFFL);
    }

    static long readNum4(byte[] byArray, int n) {
        long l = byArray[n++] & 0xFF;
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n] & 0xFF);
    }

    static void writeNum8(long l, byte[] byArray, int n) {
        n += 7;
        byArray[n--] = (byte)(l & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n--] = (byte)((l >>= 8) & 0xFFL);
        byArray[n] = (byte)((l >>= 8) & 0xFFL);
    }

    static long readNum8(byte[] byArray, int n) {
        long l = byArray[n++] & 0xFF;
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n++] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n] & 0xFF);
    }

    static void copyByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        while (n2 > 0) {
            byArray2[n3++] = byArray[n++];
            --n2;
        }
    }
}

