/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.ui.resultset;

import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartSampleFunction;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartPresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.utils.CommonUtils;

class ResultsChartConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.ResultsChartConfigDialog";
    private ResultsChartPresentation presentation;
    private CTabFolder chartTabFolder;

    ResultsChartConfigDialog(ResultsChartPresentation resultsChartPresentation) {
        super(resultsChartPresentation.getControl().getShell(), "Charts for [" + resultsChartPresentation.getController().getDataContainer().getName() + "]", null);
        this.presentation = resultsChartPresentation;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite composite) {
        Composite composite2 = super.createDialogArea(composite);
        this.chartTabFolder = new CTabFolder(composite2, 0x800082);
        this.chartTabFolder.setLayoutData((Object)new GridData(1808));
        ArrayList<ChartMeasurement> arrayList = new ArrayList<ChartMeasurement>(this.presentation.getMeasurements());
        if (arrayList.isEmpty()) {
            arrayList.add(this.presentation.createEmptyMeasurement());
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.createChartTab(this.chartTabFolder, n, (ChartMeasurement)arrayList.get(n));
            ++n;
        }
        this.chartTabFolder.setSelection(0);
        return composite;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.updateControls();
        return control;
    }

    private CTabItem createChartTab(CTabFolder cTabFolder, int n, ChartMeasurement chartMeasurement) {
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText("Chart " + (n + 1));
        cTabItem.setData((Object)chartMeasurement);
        cTabItem.setControl((Control)this.createMeasurementEditor(cTabFolder, chartMeasurement));
        return cTabItem;
    }

    private Composite createMeasurementEditor(final CTabFolder cTabFolder, final ChartMeasurement chartMeasurement) {
        Composite composite = new Composite((Composite)cTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = UIUtils.createControlGroup((Composite)composite, (String)"Axis X", (int)2, (int)768, (int)-1);
        final Combo combo = this.createColumnsCombo((Composite)group, chartMeasurement.getGroupAttributes(), chartMeasurement.getTitleX(), false);
        Composite composite2 = UIUtils.createComposite((Composite)group, (int)2);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        final Button button = UIUtils.createCheckbox((Composite)composite2, (String)"Use dictionary", (String)"Use dictionary values instead of plain numeric value", (boolean)chartMeasurement.isUseDictionaries(), (int)1);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                chartMeasurement.setUseDictionaries(button.getSelection());
            }
        });
        Object object = UIUtils.createLink((Composite)composite2, (String)"<a>Edit Dictionary</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DBSEntity dBSEntity;
                DBSEntityReferrer dBSEntityReferrer;
                DBDAttributeBinding dBDAttributeBinding = ResultsChartConfigDialog.this.getAttributeByNames(combo.getText());
                if (dBDAttributeBinding != null && (dBSEntityReferrer = ReferenceValueEditor.getEnumerableConstraint((DBDAttributeBinding)dBDAttributeBinding)) instanceof DBSEntityAssociation && (dBSEntity = ((DBSEntityAssociation)dBSEntityReferrer).getAssociatedEntity()) != null) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(dBSEntity);
                    editDictionaryPage.edit(cTabFolder.getShell());
                }
            }
        });
        object.setLayoutData((Object)new GridData(768));
        UIUtils.createInfoLabel((Composite)group, (String)"Choose unique columns for X (domain) axis", (int)768, (int)2);
        Runnable runnable = () -> this.lambda$0(combo, button, (Link)object);
        combo.addModifyListener(modifyEvent -> runnable.run());
        runnable.run();
        group = UIUtils.createControlGroup((Composite)composite, (String)"Axis Y", (int)2, (int)768, (int)-1);
        Combo combo2 = this.createColumnsCombo((Composite)group, chartMeasurement.getValueAttribute() == null ? Collections.emptyList() : Collections.singletonList(chartMeasurement.getValueAttribute()), chartMeasurement.getTitleY(), true);
        UIUtils.createInfoLabel((Composite)group, (String)"Only numeric columns can be used for Y (value) axis", (int)768, (int)2);
        group = UIUtils.createControlGroup((Composite)composite, (String)"Options", (int)4, (int)768, (int)-1);
        composite2 = UIUtils.createLabelText((Composite)group, (String)"Sample count", (String)String.valueOf(chartMeasurement.getMaxSampleCount()));
        composite2.setToolTipText("Maximum number of values (bars) to render");
        composite2.addModifyListener(arg_0 -> ResultsChartConfigDialog.lambda$2(chartMeasurement, (Text)composite2, arg_0));
        gridData = UIUtils.createLabelText((Composite)group, (String)"Row count", (String)(chartMeasurement.getMaxRowCount() <= 0 ? "" : String.valueOf(chartMeasurement.getMaxRowCount())));
        gridData.setToolTipText("Maximum number of data rows to process");
        gridData.addModifyListener(arg_0 -> ResultsChartConfigDialog.lambda$3(chartMeasurement, (Text)gridData, arg_0));
        button = UIUtils.createLabelCombo((Composite)group, (String)"Sample function", (String)"This function will be used to produce cumulative value (if domain value is not unique)", (int)12);
        ChartSampleFunction[] chartSampleFunctionArray = ChartSampleFunction.values();
        int n = chartSampleFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = chartSampleFunctionArray[n2];
            button.add(((Enum)object).name());
            ++n2;
        }
        button.setText(chartMeasurement.getSampleFunction().name());
        button.addModifyListener(arg_0 -> ResultsChartConfigDialog.lambda$4(chartMeasurement, (Combo)button, arg_0));
        combo.addModifyListener(modifyEvent -> {
            if (CommonUtils.equalObjects((Object)combo2.getText(), (Object)combo.getText())) {
                combo2.setText("");
            }
            chartMeasurement.setGroupAttributes(this.getAttributesByNames(combo.getText()));
            this.updateControls();
        });
        ((Text)combo.getData("label")).addModifyListener(modifyEvent -> {
            chartMeasurement.setTitleX(((Text)modifyEvent.widget).getText());
            this.updateControls();
        });
        combo2.addModifyListener(modifyEvent -> {
            if (CommonUtils.equalObjects((Object)combo.getText(), (Object)combo2.getText())) {
                combo.setText("");
            }
            chartMeasurement.setValueAttribute(this.getAttributeByNames(combo2.getText()));
            this.updateControls();
        });
        ((Text)combo2.getData("label")).addModifyListener(modifyEvent -> {
            chartMeasurement.setTitleY(((Text)modifyEvent.widget).getText());
            this.updateControls();
        });
        return composite;
    }

    private List<DBDAttributeBinding> getAttributesByNames(String string) {
        ArrayList<DBDAttributeBinding> arrayList = new ArrayList<DBDAttributeBinding>();
        String[] stringArray = string.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            string2 = string2.trim();
            DBDAttributeBinding dBDAttributeBinding = (DBDAttributeBinding)DBUtils.findObject((List)this.presentation.getController().getModel().getVisibleAttributes(), (String)string2);
            if (dBDAttributeBinding != null) {
                arrayList.add(dBDAttributeBinding);
            }
            ++n2;
        }
        return arrayList;
    }

    private DBDAttributeBinding getAttributeByNames(String string) {
        return (DBDAttributeBinding)DBUtils.findObject((List)this.presentation.getController().getModel().getVisibleAttributes(), (String)string);
    }

    private Combo createColumnsCombo(Composite composite, List<DBDAttributeBinding> list, String string, boolean bl) {
        Object object2;
        Combo combo = UIUtils.createLabelCombo((Composite)composite, (String)"Column", (int)12);
        combo.setLayoutData((Object)new GridData(768));
        combo.add("");
        List list2 = this.presentation.getController().getModel().getVisibleAttributes();
        for (Object object2 : list2) {
            if (bl && object2.getDataKind() != DBPDataKind.NUMERIC) continue;
            combo.add(object2.getName());
        }
        if (combo.getSelectionIndex() < 0) {
            combo.getItemCount();
        }
        object2 = new StringBuilder();
        for (DBSAttributeBase dBSAttributeBase : list) {
            if (((StringBuilder)object2).length() > 0) {
                ((StringBuilder)object2).append(", ");
            }
            ((StringBuilder)object2).append(dBSAttributeBase.getName());
        }
        combo.setText(((StringBuilder)object2).toString());
        Text text = UIUtils.createLabelText((Composite)composite, (String)"Label", (String)"", (int)2048);
        text.setLayoutData((Object)new GridData(768));
        combo.setData("label", (Object)text);
        if (string != null) {
            text.setText(string);
        }
        combo.addModifyListener(modifyEvent -> text.setText(combo.getText()));
        return combo;
    }

    private boolean isValid() {
        CTabItem[] cTabItemArray = this.chartTabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            ChartMeasurement chartMeasurement = (ChartMeasurement)cTabItem.getData();
            if (CommonUtils.isEmpty((String)chartMeasurement.getTitleY()) || CommonUtils.isEmpty((String)chartMeasurement.getTitleX()) || chartMeasurement.getGroupAttributes().isEmpty() || chartMeasurement.getValueAttribute() == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void updateControls() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.isValid());
        }
    }

    protected void okPressed() {
        ArrayList<ChartMeasurement> arrayList = new ArrayList<ChartMeasurement>();
        CTabItem[] cTabItemArray = this.chartTabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            ChartMeasurement chartMeasurement = (ChartMeasurement)cTabItem.getData();
            chartMeasurement.loadDataFromModel((DBRProgressMonitor)new VoidProgressMonitor(), this.presentation.getController());
            arrayList.add(chartMeasurement);
            ++n2;
        }
        this.presentation.setMeasurements(arrayList);
        this.presentation.refreshData(false, false, false);
        super.okPressed();
    }

    private /* synthetic */ void lambda$0(Combo combo, Button button, Link link) {
        DBDAttributeBinding dBDAttributeBinding = this.getAttributeByNames(combo.getText());
        DBSEntityReferrer dBSEntityReferrer = null;
        if (dBDAttributeBinding != null) {
            dBSEntityReferrer = ReferenceValueEditor.getEnumerableConstraint((DBDAttributeBinding)dBDAttributeBinding);
        }
        button.setEnabled(dBSEntityReferrer != null);
        link.setEnabled(dBSEntityReferrer != null);
        String string = "<a>Edit Dictionary</a>";
        if (dBSEntityReferrer != null) {
            string = String.valueOf(string) + "  (" + ((DBSEntityAssociation)dBSEntityReferrer).getAssociatedEntity().getName() + ")";
        }
        link.setText(string);
    }

    private static /* synthetic */ void lambda$2(ChartMeasurement chartMeasurement, Text text, ModifyEvent modifyEvent) {
        chartMeasurement.setMaxSampleCount(CommonUtils.toInt((Object)text.getText(), (int)0));
    }

    private static /* synthetic */ void lambda$3(ChartMeasurement chartMeasurement, Text text, ModifyEvent modifyEvent) {
        chartMeasurement.setMaxRowCount(CommonUtils.toInt((Object)text.getText(), (int)0));
    }

    private static /* synthetic */ void lambda$4(ChartMeasurement chartMeasurement, Combo combo, ModifyEvent modifyEvent) {
        chartMeasurement.setSampleFunction(ChartSampleFunction.valueOf(combo.getText()));
    }
}

